<?php

namespace EnumType;

/**
 * This class stands for FilterOp EnumType
 * @subpackage Enumerations
 */
class FilterOp
{
    /**
     * Constant for value 'and'
     * @return string 'and'
     */
    const VALUE_AND = 'and';
    /**
     * Constant for value 'or'
     * @return string 'or'
     */
    const VALUE_OR = 'or';
    /**
     * Constant for value 'not'
     * @return string 'not'
     */
    const VALUE_NOT = 'not';
    /**
     * Constant for value 'eq'
     * @return string 'eq'
     */
    const VALUE_EQ = 'eq';
    /**
     * Constant for value 'ne'
     * @return string 'ne'
     */
    const VALUE_NE = 'ne';
    /**
     * Constant for value 'gt'
     * @return string 'gt'
     */
    const VALUE_GT = 'gt';
    /**
     * Constant for value 'lt'
     * @return string 'lt'
     */
    const VALUE_LT = 'lt';
    /**
     * Constant for value 'gte'
     * @return string 'gte'
     */
    const VALUE_GTE = 'gte';
    /**
     * Constant for value 'lte'
     * @return string 'lte'
     */
    const VALUE_LTE = 'lte';
    /**
     * Constant for value 'contains'
     * @return string 'contains'
     */
    const VALUE_CONTAINS = 'contains';
    /**
     * Constant for value 'containsWord'
     * @return string 'containsWord'
     */
    const VALUE_CONTAINS_WORD = 'containsWord';
    /**
     * Constant for value 'begins'
     * @return string 'begins'
     */
    const VALUE_BEGINS = 'begins';
    /**
     * Constant for value 'exists'
     * @return string 'exists'
     */
    const VALUE_EXISTS = 'exists';
    /**
     * Constant for value 'notExist'
     * @return string 'notExist'
     */
    const VALUE_NOT_EXIST = 'notExist';
    /**
     * Constant for value 'isOf'
     * @return string 'isOf'
     */
    const VALUE_IS_OF = 'isOf';
    /**
     * Constant for value 'isNotOf'
     * @return string 'isNotOf'
     */
    const VALUE_IS_NOT_OF = 'isNotOf';
    /**
     * Constant for value 'fieldEqual'
     * @return string 'fieldEqual'
     */
    const VALUE_FIELD_EQUAL = 'fieldEqual';
    /**
     * Constant for value 'fieldGTE'
     * @return string 'fieldGTE'
     */
    const VALUE_FIELD_GTE = 'fieldGTE';
    /**
     * Constant for value 'fieldGT'
     * @return string 'fieldGT'
     */
    const VALUE_FIELD_GT = 'fieldGT';
    /**
     * Constant for value 'fieldLTE'
     * @return string 'fieldLTE'
     */
    const VALUE_FIELD_LTE = 'fieldLTE';
    /**
     * Constant for value 'fieldLT'
     * @return string 'fieldLT'
     */
    const VALUE_FIELD_LT = 'fieldLT';
    /**
     * Constant for value 'fieldNE'
     * @return string 'fieldNE'
     */
    const VALUE_FIELD_NE = 'fieldNE';
    /**
     * Constant for value 'fieldDateEqual'
     * @return string 'fieldDateEqual'
     */
    const VALUE_FIELD_DATE_EQUAL = 'fieldDateEqual';
    /**
     * Constant for value 'bitCare'
     * @return string 'bitCare'
     */
    const VALUE_BIT_CARE = 'bitCare';
    /**
     * Constant for value 'notContains'
     * @return string 'notContains'
     */
    const VALUE_NOT_CONTAINS = 'notContains';
    /**
     * Constant for value 'valid'
     * @return string 'valid'
     */
    const VALUE_VALID = 'valid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AND
     * @uses self::VALUE_OR
     * @uses self::VALUE_NOT
     * @uses self::VALUE_EQ
     * @uses self::VALUE_NE
     * @uses self::VALUE_GT
     * @uses self::VALUE_LT
     * @uses self::VALUE_GTE
     * @uses self::VALUE_LTE
     * @uses self::VALUE_CONTAINS
     * @uses self::VALUE_CONTAINS_WORD
     * @uses self::VALUE_BEGINS
     * @uses self::VALUE_EXISTS
     * @uses self::VALUE_NOT_EXIST
     * @uses self::VALUE_IS_OF
     * @uses self::VALUE_IS_NOT_OF
     * @uses self::VALUE_FIELD_EQUAL
     * @uses self::VALUE_FIELD_GTE
     * @uses self::VALUE_FIELD_GT
     * @uses self::VALUE_FIELD_LTE
     * @uses self::VALUE_FIELD_LT
     * @uses self::VALUE_FIELD_NE
     * @uses self::VALUE_FIELD_DATE_EQUAL
     * @uses self::VALUE_BIT_CARE
     * @uses self::VALUE_NOT_CONTAINS
     * @uses self::VALUE_VALID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AND,
            self::VALUE_OR,
            self::VALUE_NOT,
            self::VALUE_EQ,
            self::VALUE_NE,
            self::VALUE_GT,
            self::VALUE_LT,
            self::VALUE_GTE,
            self::VALUE_LTE,
            self::VALUE_CONTAINS,
            self::VALUE_CONTAINS_WORD,
            self::VALUE_BEGINS,
            self::VALUE_EXISTS,
            self::VALUE_NOT_EXIST,
            self::VALUE_IS_OF,
            self::VALUE_IS_NOT_OF,
            self::VALUE_FIELD_EQUAL,
            self::VALUE_FIELD_GTE,
            self::VALUE_FIELD_GT,
            self::VALUE_FIELD_LTE,
            self::VALUE_FIELD_LT,
            self::VALUE_FIELD_NE,
            self::VALUE_FIELD_DATE_EQUAL,
            self::VALUE_BIT_CARE,
            self::VALUE_NOT_CONTAINS,
            self::VALUE_VALID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
