<?php

namespace EnumType;

/**
 * This class stands for FilterDate EnumType
 * @subpackage Enumerations
 */
class FilterDate
{
    /**
     * Constant for value 'Today'
     * @return string 'Today'
     */
    const VALUE_TODAY = 'Today';
    /**
     * Constant for value 'Tomorrow'
     * @return string 'Tomorrow'
     */
    const VALUE_TOMORROW = 'Tomorrow';
    /**
     * Constant for value 'ThisMonth'
     * @return string 'ThisMonth'
     */
    const VALUE_THIS_MONTH = 'ThisMonth';
    /**
     * Constant for value 'ThisWeek'
     * @return string 'ThisWeek'
     */
    const VALUE_THIS_WEEK = 'ThisWeek';
    /**
     * Constant for value 'ThisYear'
     * @return string 'ThisYear'
     */
    const VALUE_THIS_YEAR = 'ThisYear';
    /**
     * Constant for value 'Yesterday'
     * @return string 'Yesterday'
     */
    const VALUE_YESTERDAY = 'Yesterday';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TODAY
     * @uses self::VALUE_TOMORROW
     * @uses self::VALUE_THIS_MONTH
     * @uses self::VALUE_THIS_WEEK
     * @uses self::VALUE_THIS_YEAR
     * @uses self::VALUE_YESTERDAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TODAY,
            self::VALUE_TOMORROW,
            self::VALUE_THIS_MONTH,
            self::VALUE_THIS_WEEK,
            self::VALUE_THIS_YEAR,
            self::VALUE_YESTERDAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
