<?php

namespace EnumType;

/**
 * This class stands for Field EnumType
 * @subpackage Enumerations
 */
class Field
{
    /**
     * Constant for value 'AcceptLevel'
     * @return string 'AcceptLevel'
     */
    const VALUE_ACCEPT_LEVEL = 'AcceptLevel';
    /**
     * Constant for value 'Alarm'
     * @return string 'Alarm'
     */
    const VALUE_ALARM = 'Alarm';
    /**
     * Constant for value 'AllDayEvent'
     * @return string 'AllDayEvent'
     */
    const VALUE_ALL_DAY_EVENT = 'AllDayEvent';
    /**
     * Constant for value 'Attachment'
     * @return string 'Attachment'
     */
    const VALUE_ATTACHMENT = 'Attachment';
    /**
     * Constant for value 'Category'
     * @return string 'Category'
     */
    const VALUE_CATEGORY = 'Category';
    /**
     * Constant for value 'Checklist'
     * @return string 'Checklist'
     */
    const VALUE_CHECKLIST = 'Checklist';
    /**
     * Constant for value 'Classification'
     * @return string 'Classification'
     */
    const VALUE_CLASSIFICATION = 'Classification';
    /**
     * Constant for value 'Contact'
     * @return string 'Contact'
     */
    const VALUE_CONTACT = 'Contact';
    /**
     * Constant for value 'DueDate'
     * @return string 'DueDate'
     */
    const VALUE_DUE_DATE = 'DueDate';
    /**
     * Constant for value 'Duration'
     * @return string 'Duration'
     */
    const VALUE_DURATION = 'Duration';
    /**
     * Constant for value 'EmailAddress'
     * @return string 'EmailAddress'
     */
    const VALUE_EMAIL_ADDRESS = 'EmailAddress';
    /**
     * Constant for value 'ExpirationDate'
     * @return string 'ExpirationDate'
     */
    const VALUE_EXPIRATION_DATE = 'ExpirationDate';
    /**
     * Constant for value 'Hidden'
     * @return string 'Hidden'
     */
    const VALUE_HIDDEN = 'Hidden';
    /**
     * Constant for value 'IMAddress'
     * @return string 'IMAddress'
     */
    const VALUE_IMADDRESS = 'IMAddress';
    /**
     * Constant for value 'MessageBody'
     * @return string 'MessageBody'
     */
    const VALUE_MESSAGE_BODY = 'MessageBody';
    /**
     * Constant for value 'Name'
     * @return string 'Name'
     */
    const VALUE_NAME = 'Name';
    /**
     * Constant for value 'Organization'
     * @return string 'Organization'
     */
    const VALUE_ORGANIZATION = 'Organization';
    /**
     * Constant for value 'Owner'
     * @return string 'Owner'
     */
    const VALUE_OWNER = 'Owner';
    /**
     * Constant for value 'Parent'
     * @return string 'Parent'
     */
    const VALUE_PARENT = 'Parent';
    /**
     * Constant for value 'PersonalSubject'
     * @return string 'PersonalSubject'
     */
    const VALUE_PERSONAL_SUBJECT = 'PersonalSubject';
    /**
     * Constant for value 'PhoneNumber'
     * @return string 'PhoneNumber'
     */
    const VALUE_PHONE_NUMBER = 'PhoneNumber';
    /**
     * Constant for value 'Picture'
     * @return string 'Picture'
     */
    const VALUE_PICTURE = 'Picture';
    /**
     * Constant for value 'Place'
     * @return string 'Place'
     */
    const VALUE_PLACE = 'Place';
    /**
     * Constant for value 'PostalAddress'
     * @return string 'PostalAddress'
     */
    const VALUE_POSTAL_ADDRESS = 'PostalAddress';
    /**
     * Constant for value 'RecipientStatus'
     * @return string 'RecipientStatus'
     */
    const VALUE_RECIPIENT_STATUS = 'RecipientStatus';
    /**
     * Constant for value 'Rights'
     * @return string 'Rights'
     */
    const VALUE_RIGHTS = 'Rights';
    /**
     * Constant for value 'Security'
     * @return string 'Security'
     */
    const VALUE_SECURITY = 'Security';
    /**
     * Constant for value 'SendPriority'
     * @return string 'SendPriority'
     */
    const VALUE_SEND_PRIORITY = 'SendPriority';
    /**
     * Constant for value 'StartDate'
     * @return string 'StartDate'
     */
    const VALUE_START_DATE = 'StartDate';
    /**
     * Constant for value 'Subject'
     * @return string 'Subject'
     */
    const VALUE_SUBJECT = 'Subject';
    /**
     * Constant for value 'TaskCategory'
     * @return string 'TaskCategory'
     */
    const VALUE_TASK_CATEGORY = 'TaskCategory';
    /**
     * Constant for value 'TaskPriority'
     * @return string 'TaskPriority'
     */
    const VALUE_TASK_PRIORITY = 'TaskPriority';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPT_LEVEL
     * @uses self::VALUE_ALARM
     * @uses self::VALUE_ALL_DAY_EVENT
     * @uses self::VALUE_ATTACHMENT
     * @uses self::VALUE_CATEGORY
     * @uses self::VALUE_CHECKLIST
     * @uses self::VALUE_CLASSIFICATION
     * @uses self::VALUE_CONTACT
     * @uses self::VALUE_DUE_DATE
     * @uses self::VALUE_DURATION
     * @uses self::VALUE_EMAIL_ADDRESS
     * @uses self::VALUE_EXPIRATION_DATE
     * @uses self::VALUE_HIDDEN
     * @uses self::VALUE_IMADDRESS
     * @uses self::VALUE_MESSAGE_BODY
     * @uses self::VALUE_NAME
     * @uses self::VALUE_ORGANIZATION
     * @uses self::VALUE_OWNER
     * @uses self::VALUE_PARENT
     * @uses self::VALUE_PERSONAL_SUBJECT
     * @uses self::VALUE_PHONE_NUMBER
     * @uses self::VALUE_PICTURE
     * @uses self::VALUE_PLACE
     * @uses self::VALUE_POSTAL_ADDRESS
     * @uses self::VALUE_RECIPIENT_STATUS
     * @uses self::VALUE_RIGHTS
     * @uses self::VALUE_SECURITY
     * @uses self::VALUE_SEND_PRIORITY
     * @uses self::VALUE_START_DATE
     * @uses self::VALUE_SUBJECT
     * @uses self::VALUE_TASK_CATEGORY
     * @uses self::VALUE_TASK_PRIORITY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPT_LEVEL,
            self::VALUE_ALARM,
            self::VALUE_ALL_DAY_EVENT,
            self::VALUE_ATTACHMENT,
            self::VALUE_CATEGORY,
            self::VALUE_CHECKLIST,
            self::VALUE_CLASSIFICATION,
            self::VALUE_CONTACT,
            self::VALUE_DUE_DATE,
            self::VALUE_DURATION,
            self::VALUE_EMAIL_ADDRESS,
            self::VALUE_EXPIRATION_DATE,
            self::VALUE_HIDDEN,
            self::VALUE_IMADDRESS,
            self::VALUE_MESSAGE_BODY,
            self::VALUE_NAME,
            self::VALUE_ORGANIZATION,
            self::VALUE_OWNER,
            self::VALUE_PARENT,
            self::VALUE_PERSONAL_SUBJECT,
            self::VALUE_PHONE_NUMBER,
            self::VALUE_PICTURE,
            self::VALUE_PLACE,
            self::VALUE_POSTAL_ADDRESS,
            self::VALUE_RECIPIENT_STATUS,
            self::VALUE_RIGHTS,
            self::VALUE_SECURITY,
            self::VALUE_SEND_PRIORITY,
            self::VALUE_START_DATE,
            self::VALUE_SUBJECT,
            self::VALUE_TASK_CATEGORY,
            self::VALUE_TASK_PRIORITY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
