<?php

namespace EnumType;

/**
 * This class stands for EventType EnumType
 * @subpackage Enumerations
 */
class EventType
{
    /**
     * Constant for value 'AddressBookAdd'
     * @return string 'AddressBookAdd'
     */
    const VALUE_ADDRESS_BOOK_ADD = 'AddressBookAdd';
    /**
     * Constant for value 'AddressBookDelete'
     * @return string 'AddressBookDelete'
     */
    const VALUE_ADDRESS_BOOK_DELETE = 'AddressBookDelete';
    /**
     * Constant for value 'AddressBookModify'
     * @return string 'AddressBookModify'
     */
    const VALUE_ADDRESS_BOOK_MODIFY = 'AddressBookModify';
    /**
     * Constant for value 'AddressBookItemAdd'
     * @return string 'AddressBookItemAdd'
     */
    const VALUE_ADDRESS_BOOK_ITEM_ADD = 'AddressBookItemAdd';
    /**
     * Constant for value 'AddressBookItemDelete'
     * @return string 'AddressBookItemDelete'
     */
    const VALUE_ADDRESS_BOOK_ITEM_DELETE = 'AddressBookItemDelete';
    /**
     * Constant for value 'AddressBookItemModify'
     * @return string 'AddressBookItemModify'
     */
    const VALUE_ADDRESS_BOOK_ITEM_MODIFY = 'AddressBookItemModify';
    /**
     * Constant for value 'FolderAccept'
     * @return string 'FolderAccept'
     */
    const VALUE_FOLDER_ACCEPT = 'FolderAccept';
    /**
     * Constant for value 'FolderAdd'
     * @return string 'FolderAdd'
     */
    const VALUE_FOLDER_ADD = 'FolderAdd';
    /**
     * Constant for value 'FolderDelete'
     * @return string 'FolderDelete'
     */
    const VALUE_FOLDER_DELETE = 'FolderDelete';
    /**
     * Constant for value 'FolderItemAdd'
     * @return string 'FolderItemAdd'
     */
    const VALUE_FOLDER_ITEM_ADD = 'FolderItemAdd';
    /**
     * Constant for value 'FolderItemDelete'
     * @return string 'FolderItemDelete'
     */
    const VALUE_FOLDER_ITEM_DELETE = 'FolderItemDelete';
    /**
     * Constant for value 'FolderItemMove'
     * @return string 'FolderItemMove'
     */
    const VALUE_FOLDER_ITEM_MOVE = 'FolderItemMove';
    /**
     * Constant for value 'FolderModify'
     * @return string 'FolderModify'
     */
    const VALUE_FOLDER_MODIFY = 'FolderModify';
    /**
     * Constant for value 'ItemAccept'
     * @return string 'ItemAccept'
     */
    const VALUE_ITEM_ACCEPT = 'ItemAccept';
    /**
     * Constant for value 'ItemArchive'
     * @return string 'ItemArchive'
     */
    const VALUE_ITEM_ARCHIVE = 'ItemArchive';
    /**
     * Constant for value 'ItemComplete'
     * @return string 'ItemComplete'
     */
    const VALUE_ITEM_COMPLETE = 'ItemComplete';
    /**
     * Constant for value 'ItemDecline'
     * @return string 'ItemDecline'
     */
    const VALUE_ITEM_DECLINE = 'ItemDecline';
    /**
     * Constant for value 'ItemDelete'
     * @return string 'ItemDelete'
     */
    const VALUE_ITEM_DELETE = 'ItemDelete';
    /**
     * Constant for value 'ItemMarkPrivate'
     * @return string 'ItemMarkPrivate'
     */
    const VALUE_ITEM_MARK_PRIVATE = 'ItemMarkPrivate';
    /**
     * Constant for value 'ItemMarkRead'
     * @return string 'ItemMarkRead'
     */
    const VALUE_ITEM_MARK_READ = 'ItemMarkRead';
    /**
     * Constant for value 'ItemMarkUnread'
     * @return string 'ItemMarkUnread'
     */
    const VALUE_ITEM_MARK_UNREAD = 'ItemMarkUnread';
    /**
     * Constant for value 'ItemModify'
     * @return string 'ItemModify'
     */
    const VALUE_ITEM_MODIFY = 'ItemModify';
    /**
     * Constant for value 'ItemPurge'
     * @return string 'ItemPurge'
     */
    const VALUE_ITEM_PURGE = 'ItemPurge';
    /**
     * Constant for value 'ItemUnarchive'
     * @return string 'ItemUnarchive'
     */
    const VALUE_ITEM_UNARCHIVE = 'ItemUnarchive';
    /**
     * Constant for value 'ItemUndelete'
     * @return string 'ItemUndelete'
     */
    const VALUE_ITEM_UNDELETE = 'ItemUndelete';
    /**
     * Constant for value 'Login'
     * @return string 'Login'
     */
    const VALUE_LOGIN = 'Login';
    /**
     * Constant for value 'Logout'
     * @return string 'Logout'
     */
    const VALUE_LOGOUT = 'Logout';
    /**
     * Constant for value 'ProxyAccessAdd'
     * @return string 'ProxyAccessAdd'
     */
    const VALUE_PROXY_ACCESS_ADD = 'ProxyAccessAdd';
    /**
     * Constant for value 'ProxyAccessModify'
     * @return string 'ProxyAccessModify'
     */
    const VALUE_PROXY_ACCESS_MODIFY = 'ProxyAccessModify';
    /**
     * Constant for value 'ProxyAccessDelete'
     * @return string 'ProxyAccessDelete'
     */
    const VALUE_PROXY_ACCESS_DELETE = 'ProxyAccessDelete';
    /**
     * Constant for value 'ProxyLogin'
     * @return string 'ProxyLogin'
     */
    const VALUE_PROXY_LOGIN = 'ProxyLogin';
    /**
     * Constant for value 'SessionTimedOut'
     * @return string 'SessionTimedOut'
     */
    const VALUE_SESSION_TIMED_OUT = 'SessionTimedOut';
    /**
     * Constant for value 'TrustedApplicationLogin'
     * @return string 'TrustedApplicationLogin'
     */
    const VALUE_TRUSTED_APPLICATION_LOGIN = 'TrustedApplicationLogin';
    /**
     * Constant for value 'ItemMarkUnprivate'
     * @return string 'ItemMarkUnprivate'
     */
    const VALUE_ITEM_MARK_UNPRIVATE = 'ItemMarkUnprivate';
    /**
     * Constant for value 'ItemUnaccept'
     * @return string 'ItemUnaccept'
     */
    const VALUE_ITEM_UNACCEPT = 'ItemUnaccept';
    /**
     * Constant for value 'ItemUncomplete'
     * @return string 'ItemUncomplete'
     */
    const VALUE_ITEM_UNCOMPLETE = 'ItemUncomplete';
    /**
     * Constant for value 'PersonalGroupItemAdd'
     * @return string 'PersonalGroupItemAdd'
     */
    const VALUE_PERSONAL_GROUP_ITEM_ADD = 'PersonalGroupItemAdd';
    /**
     * Constant for value 'PersonalGroupItemDelete'
     * @return string 'PersonalGroupItemDelete'
     */
    const VALUE_PERSONAL_GROUP_ITEM_DELETE = 'PersonalGroupItemDelete';
    /**
     * Constant for value 'UserMoveComplete'
     * @return string 'UserMoveComplete'
     */
    const VALUE_USER_MOVE_COMPLETE = 'UserMoveComplete';
    /**
     * Constant for value 'RuleAdd'
     * @return string 'RuleAdd'
     */
    const VALUE_RULE_ADD = 'RuleAdd';
    /**
     * Constant for value 'RuleDelete'
     * @return string 'RuleDelete'
     */
    const VALUE_RULE_DELETE = 'RuleDelete';
    /**
     * Constant for value 'RuleModify'
     * @return string 'RuleModify'
     */
    const VALUE_RULE_MODIFY = 'RuleModify';
    /**
     * Constant for value 'RuleExecute'
     * @return string 'RuleExecute'
     */
    const VALUE_RULE_EXECUTE = 'RuleExecute';
    /**
     * Constant for value 'ItemForward'
     * @return string 'ItemForward'
     */
    const VALUE_ITEM_FORWARD = 'ItemForward';
    /**
     * Constant for value 'ItemReply'
     * @return string 'ItemReply'
     */
    const VALUE_ITEM_REPLY = 'ItemReply';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADDRESS_BOOK_ADD
     * @uses self::VALUE_ADDRESS_BOOK_DELETE
     * @uses self::VALUE_ADDRESS_BOOK_MODIFY
     * @uses self::VALUE_ADDRESS_BOOK_ITEM_ADD
     * @uses self::VALUE_ADDRESS_BOOK_ITEM_DELETE
     * @uses self::VALUE_ADDRESS_BOOK_ITEM_MODIFY
     * @uses self::VALUE_FOLDER_ACCEPT
     * @uses self::VALUE_FOLDER_ADD
     * @uses self::VALUE_FOLDER_DELETE
     * @uses self::VALUE_FOLDER_ITEM_ADD
     * @uses self::VALUE_FOLDER_ITEM_DELETE
     * @uses self::VALUE_FOLDER_ITEM_MOVE
     * @uses self::VALUE_FOLDER_MODIFY
     * @uses self::VALUE_ITEM_ACCEPT
     * @uses self::VALUE_ITEM_ARCHIVE
     * @uses self::VALUE_ITEM_COMPLETE
     * @uses self::VALUE_ITEM_DECLINE
     * @uses self::VALUE_ITEM_DELETE
     * @uses self::VALUE_ITEM_MARK_PRIVATE
     * @uses self::VALUE_ITEM_MARK_READ
     * @uses self::VALUE_ITEM_MARK_UNREAD
     * @uses self::VALUE_ITEM_MODIFY
     * @uses self::VALUE_ITEM_PURGE
     * @uses self::VALUE_ITEM_UNARCHIVE
     * @uses self::VALUE_ITEM_UNDELETE
     * @uses self::VALUE_LOGIN
     * @uses self::VALUE_LOGOUT
     * @uses self::VALUE_PROXY_ACCESS_ADD
     * @uses self::VALUE_PROXY_ACCESS_MODIFY
     * @uses self::VALUE_PROXY_ACCESS_DELETE
     * @uses self::VALUE_PROXY_LOGIN
     * @uses self::VALUE_SESSION_TIMED_OUT
     * @uses self::VALUE_TRUSTED_APPLICATION_LOGIN
     * @uses self::VALUE_ITEM_MARK_UNPRIVATE
     * @uses self::VALUE_ITEM_UNACCEPT
     * @uses self::VALUE_ITEM_UNCOMPLETE
     * @uses self::VALUE_PERSONAL_GROUP_ITEM_ADD
     * @uses self::VALUE_PERSONAL_GROUP_ITEM_DELETE
     * @uses self::VALUE_USER_MOVE_COMPLETE
     * @uses self::VALUE_RULE_ADD
     * @uses self::VALUE_RULE_DELETE
     * @uses self::VALUE_RULE_MODIFY
     * @uses self::VALUE_RULE_EXECUTE
     * @uses self::VALUE_ITEM_FORWARD
     * @uses self::VALUE_ITEM_REPLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADDRESS_BOOK_ADD,
            self::VALUE_ADDRESS_BOOK_DELETE,
            self::VALUE_ADDRESS_BOOK_MODIFY,
            self::VALUE_ADDRESS_BOOK_ITEM_ADD,
            self::VALUE_ADDRESS_BOOK_ITEM_DELETE,
            self::VALUE_ADDRESS_BOOK_ITEM_MODIFY,
            self::VALUE_FOLDER_ACCEPT,
            self::VALUE_FOLDER_ADD,
            self::VALUE_FOLDER_DELETE,
            self::VALUE_FOLDER_ITEM_ADD,
            self::VALUE_FOLDER_ITEM_DELETE,
            self::VALUE_FOLDER_ITEM_MOVE,
            self::VALUE_FOLDER_MODIFY,
            self::VALUE_ITEM_ACCEPT,
            self::VALUE_ITEM_ARCHIVE,
            self::VALUE_ITEM_COMPLETE,
            self::VALUE_ITEM_DECLINE,
            self::VALUE_ITEM_DELETE,
            self::VALUE_ITEM_MARK_PRIVATE,
            self::VALUE_ITEM_MARK_READ,
            self::VALUE_ITEM_MARK_UNREAD,
            self::VALUE_ITEM_MODIFY,
            self::VALUE_ITEM_PURGE,
            self::VALUE_ITEM_UNARCHIVE,
            self::VALUE_ITEM_UNDELETE,
            self::VALUE_LOGIN,
            self::VALUE_LOGOUT,
            self::VALUE_PROXY_ACCESS_ADD,
            self::VALUE_PROXY_ACCESS_MODIFY,
            self::VALUE_PROXY_ACCESS_DELETE,
            self::VALUE_PROXY_LOGIN,
            self::VALUE_SESSION_TIMED_OUT,
            self::VALUE_TRUSTED_APPLICATION_LOGIN,
            self::VALUE_ITEM_MARK_UNPRIVATE,
            self::VALUE_ITEM_UNACCEPT,
            self::VALUE_ITEM_UNCOMPLETE,
            self::VALUE_PERSONAL_GROUP_ITEM_ADD,
            self::VALUE_PERSONAL_GROUP_ITEM_DELETE,
            self::VALUE_USER_MOVE_COMPLETE,
            self::VALUE_RULE_ADD,
            self::VALUE_RULE_DELETE,
            self::VALUE_RULE_MODIFY,
            self::VALUE_RULE_EXECUTE,
            self::VALUE_ITEM_FORWARD,
            self::VALUE_ITEM_REPLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
