<?php

namespace EnumType;

/**
 * This class stands for ContactType EnumType
 * @subpackage Enumerations
 */
class ContactType
{
    /**
     * Constant for value 'Contact'
     * @return string 'Contact'
     */
    const VALUE_CONTACT = 'Contact';
    /**
     * Constant for value 'Group'
     * @return string 'Group'
     */
    const VALUE_GROUP = 'Group';
    /**
     * Constant for value 'Resource'
     * @return string 'Resource'
     */
    const VALUE_RESOURCE = 'Resource';
    /**
     * Constant for value 'Organization'
     * @return string 'Organization'
     */
    const VALUE_ORGANIZATION = 'Organization';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTACT
     * @uses self::VALUE_GROUP
     * @uses self::VALUE_RESOURCE
     * @uses self::VALUE_ORGANIZATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTACT,
            self::VALUE_GROUP,
            self::VALUE_RESOURCE,
            self::VALUE_ORGANIZATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
