<?php

namespace EnumType;

/**
 * This class stands for ColumnType EnumType
 * @subpackage Enumerations
 */
class ColumnType
{
    /**
     * Constant for value 'Windows'
     * @return string 'Windows'
     */
    const VALUE_WINDOWS = 'Windows';
    /**
     * Constant for value 'Java'
     * @return string 'Java'
     */
    const VALUE_JAVA = 'Java';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WINDOWS
     * @uses self::VALUE_JAVA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WINDOWS,
            self::VALUE_JAVA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
