<?php

namespace EnumType;

/**
 * This class stands for CategoryType EnumType
 * @subpackage Enumerations
 */
class CategoryType
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Personal'
     * @return string 'Personal'
     */
    const VALUE_PERSONAL = 'Personal';
    /**
     * Constant for value 'FollowUp'
     * @return string 'FollowUp'
     */
    const VALUE_FOLLOW_UP = 'FollowUp';
    /**
     * Constant for value 'Urgent'
     * @return string 'Urgent'
     */
    const VALUE_URGENT = 'Urgent';
    /**
     * Constant for value 'LowPriority'
     * @return string 'LowPriority'
     */
    const VALUE_LOW_PRIORITY = 'LowPriority';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_PERSONAL
     * @uses self::VALUE_FOLLOW_UP
     * @uses self::VALUE_URGENT
     * @uses self::VALUE_LOW_PRIORITY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_PERSONAL,
            self::VALUE_FOLLOW_UP,
            self::VALUE_URGENT,
            self::VALUE_LOW_PRIORITY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
