<?php

namespace EnumType;

/**
 * This class stands for CalendarViewType EnumType
 * @subpackage Enumerations
 */
class CalendarViewType
{
    /**
     * Constant for value 'day'
     * @return string 'day'
     */
    const VALUE_DAY = 'day';
    /**
     * Constant for value 'month'
     * @return string 'month'
     */
    const VALUE_MONTH = 'month';
    /**
     * Constant for value 'multiUser'
     * @return string 'multiUser'
     */
    const VALUE_MULTI_USER = 'multiUser';
    /**
     * Constant for value 'week'
     * @return string 'week'
     */
    const VALUE_WEEK = 'week';
    /**
     * Constant for value 'year'
     * @return string 'year'
     */
    const VALUE_YEAR = 'year';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAY
     * @uses self::VALUE_MONTH
     * @uses self::VALUE_MULTI_USER
     * @uses self::VALUE_WEEK
     * @uses self::VALUE_YEAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAY,
            self::VALUE_MONTH,
            self::VALUE_MULTI_USER,
            self::VALUE_WEEK,
            self::VALUE_YEAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
