<?php

namespace EnumType;

/**
 * This class stands for CalendarFolderFlags EnumType
 * @subpackage Enumerations
 */
class CalendarFolderFlags
{
    /**
     * Constant for value 'ShowInList'
     * @return string 'ShowInList'
     */
    const VALUE_SHOW_IN_LIST = 'ShowInList';
    /**
     * Constant for value 'DontIncludeContent'
     * @return string 'DontIncludeContent'
     */
    const VALUE_DONT_INCLUDE_CONTENT = 'DontIncludeContent';
    /**
     * Constant for value 'Publish'
     * @return string 'Publish'
     */
    const VALUE_PUBLISH = 'Publish';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SHOW_IN_LIST
     * @uses self::VALUE_DONT_INCLUDE_CONTENT
     * @uses self::VALUE_PUBLISH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SHOW_IN_LIST,
            self::VALUE_DONT_INCLUDE_CONTENT,
            self::VALUE_PUBLISH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
