<?php

namespace EnumType;

/**
 * This class stands for AgeAction EnumType
 * @subpackage Enumerations
 */
class AgeAction
{
    /**
     * Constant for value 'archive'
     * @return string 'archive'
     */
    const VALUE_ARCHIVE = 'archive';
    /**
     * Constant for value 'delete'
     * @return string 'delete'
     */
    const VALUE_DELETE = 'delete';
    /**
     * Constant for value 'retain'
     * @return string 'retain'
     */
    const VALUE_RETAIN = 'retain';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARCHIVE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_RETAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARCHIVE,
            self::VALUE_DELETE,
            self::VALUE_RETAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
