<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://fozzil.net/apps/gw/2014r2/groupwise.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://fozzil.net/apps/gw/2014r2/groupwise.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Accept ServiceType
 */
$accept = new \ServiceType\Accept($options);
$accept->setSoapHeaderSession($session);
$accept->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for acceptRequest operation/method
 */
if ($accept->acceptRequest(new \StructType\AcceptRequest()) !== false) {
    print_r($accept->getResult());
} else {
    print_r($accept->getLastError());
}
/**
 * Sample call for acceptShareRequest operation/method
 */
if ($accept->acceptShareRequest(new \StructType\AcceptShareRequest()) !== false) {
    print_r($accept->getResult());
} else {
    print_r($accept->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderSession($session);
$add->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for addItemRequest operation/method
 */
if ($add->addItemRequest(new \StructType\AddItemRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addItemsRequest operation/method
 */
if ($add->addItemsRequest(new \StructType\AddItemsRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMembersRequest operation/method
 */
if ($add->addMembersRequest(new \StructType\AddMembersRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Archive ServiceType
 */
$archive = new \ServiceType\Archive($options);
$archive->setSoapHeaderSession($session);
$archive->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for archiveRequest operation/method
 */
if ($archive->archiveRequest(new \StructType\ArchiveRequest()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \ServiceType\Close($options);
$close->setSoapHeaderSession($session);
$close->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for closeFreeBusySessionRequest operation/method
 */
if ($close->closeFreeBusySessionRequest(new \StructType\CloseFreeBusySessionRequest()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Complete ServiceType
 */
$complete = new \ServiceType\Complete($options);
$complete->setSoapHeaderSession($session);
$complete->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for completeRequest operation/method
 */
if ($complete->completeRequest(new \StructType\CompleteRequest()) !== false) {
    print_r($complete->getResult());
} else {
    print_r($complete->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderSession($session);
$create->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for createCursorRequest operation/method
 */
if ($create->createCursorRequest(new \StructType\CreateCursorRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createItemRequest operation/method
 */
if ($create->createItemRequest(new \StructType\CreateItemRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createItemsRequest operation/method
 */
if ($create->createItemsRequest(new \StructType\CreateItemsRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createJunkEntryRequest operation/method
 */
if ($create->createJunkEntryRequest(new \StructType\CreateJunkEntryRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createNotifyRequest operation/method
 */
if ($create->createNotifyRequest(new \StructType\CreateNotifyRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createProxyAccessRequest operation/method
 */
if ($create->createProxyAccessRequest(new \StructType\CreateProxyAccessRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createSignatureRequest operation/method
 */
if ($create->createSignatureRequest(new \StructType\CreateSignatureRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Decline ServiceType
 */
$decline = new \ServiceType\Decline($options);
$decline->setSoapHeaderSession($session);
$decline->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for declineRequest operation/method
 */
if ($decline->declineRequest(new \StructType\DeclineRequest()) !== false) {
    print_r($decline->getResult());
} else {
    print_r($decline->getLastError());
}
/**
 * Samples for Delegate ServiceType
 */
$delegate = new \ServiceType\Delegate($options);
$delegate->setSoapHeaderSession($session);
$delegate->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for delegateRequest operation/method
 */
if ($delegate->delegateRequest(new \StructType\DelegateRequest()) !== false) {
    print_r($delegate->getResult());
} else {
    print_r($delegate->getLastError());
}
/**
 * Samples for Destroy ServiceType
 */
$destroy = new \ServiceType\Destroy($options);
$destroy->setSoapHeaderSession($session);
$destroy->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for destroyCursorRequest operation/method
 */
if ($destroy->destroyCursorRequest(new \StructType\DestroyCursorRequest()) !== false) {
    print_r($destroy->getResult());
} else {
    print_r($destroy->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \ServiceType\Execute($options);
$execute->setSoapHeaderSession($session);
$execute->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for executeRuleRequest operation/method
 */
if ($execute->executeRuleRequest(new \StructType\ExecuteRuleRequest()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Forward ServiceType
 */
$forward = new \ServiceType\Forward($options);
$forward->setSoapHeaderSession($session);
$forward->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for forwardRequest operation/method
 */
if ($forward->forwardRequest(new \StructType\ForwardRequest()) !== false) {
    print_r($forward->getResult());
} else {
    print_r($forward->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderSession($session);
$get->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for getAccountListRequest operation/method
 */
if ($get->getAccountListRequest(new \StructType\GetAccountListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAddressBookListRequest operation/method
 */
if ($get->getAddressBookListRequest(new \StructType\GetAddressBookListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getArchiveItemsRequest operation/method
 */
if ($get->getArchiveItemsRequest(new \StructType\GetArchiveItemsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAttachmentRequestMessage operation/method
 */
if ($get->getAttachmentRequestMessage(new \StructType\GetAttachmentRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCategoryListRequest operation/method
 */
if ($get->getCategoryListRequest(new \StructType\GetCategoryListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContactHistoryFilterRequest operation/method
 */
if ($get->getContactHistoryFilterRequest(new \StructType\GetContactHistoryFilterRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomListRequest operation/method
 */
if ($get->getCustomListRequest(new \StructType\GetCustomListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeltasRequest operation/method
 */
if ($get->getDeltasRequest(new \StructType\GetDeltasRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeltaInfoRequest operation/method
 */
if ($get->getDeltaInfoRequest(new \StructType\GetDeltaInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDiskSpaceUsageRequest operation/method
 */
if ($get->getDiskSpaceUsageRequest(new \StructType\GetDiskSpaceUsageRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDocumentTypeListRequest operation/method
 */
if ($get->getDocumentTypeListRequest(new \StructType\GetDocumentTypeListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFolderRequest operation/method
 */
if ($get->getFolderRequest(new \StructType\GetFolderRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFolderListRequest operation/method
 */
if ($get->getFolderListRequest(new \StructType\GetFolderListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFreeBusyRequest operation/method
 */
if ($get->getFreeBusyRequest(new \StructType\GetFreeBusyRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getItemRequest operation/method
 */
if ($get->getItemRequest(new \StructType\GetItemRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getItemsRequest operation/method
 */
if ($get->getItemsRequest(new \StructType\GetItemsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getJunkEntriesRequest operation/method
 */
if ($get->getJunkEntriesRequest(new \StructType\GetJunkEntriesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getJunkMailSettingsRequest operation/method
 */
if ($get->getJunkMailSettingsRequest(new \StructType\GetJunkMailSettingsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLibraryItemRequest operation/method
 */
if ($get->getLibraryItemRequest(new \StructType\GetLibraryItemRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLibraryListRequest operation/method
 */
if ($get->getLibraryListRequest(new \StructType\GetLibraryListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMemberOfRequest operation/method
 */
if ($get->getMemberOfRequest(new \StructType\GetMemberOfRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNotifyListRequest operation/method
 */
if ($get->getNotifyListRequest(new \StructType\GetNotifyListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getQuickMessagesRequest operation/method
 */
if ($get->getQuickMessagesRequest(new \StructType\GetQuickMessagesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProxyAccessListRequest operation/method
 */
if ($get->getProxyAccessListRequest(new \StructType\GetProxyAccessListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProxyListRequest operation/method
 */
if ($get->getProxyListRequest(new \StructType\GetProxyListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRuleListRequest operation/method
 */
if ($get->getRuleListRequest(new \StructType\GetRuleListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSettingsRequest operation/method
 */
if ($get->getSettingsRequest(new \StructType\GetSettingsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSignaturesRequest operation/method
 */
if ($get->getSignaturesRequest(new \StructType\GetSignaturesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStringRequest operation/method
 */
if ($get->getStringRequest(new \StructType\GetStringRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTimestampRequest operation/method
 */
if ($get->getTimestampRequest(new \StructType\GetTimestampRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTimezoneListRequest operation/method
 */
if ($get->getTimezoneListRequest(new \StructType\GetTimezoneListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUnreadRequest operation/method
 */
if ($get->getUnreadRequest(new \StructType\GetUnreadRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserListRequest operation/method
 */
if ($get->getUserListRequest(new \StructType\GetUserListRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEventConfigurationRequest operation/method
 */
if ($get->getEventConfigurationRequest(new \StructType\GetEventConfigurationRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEventsRequest operation/method
 */
if ($get->getEventsRequest(new \StructType\GetEventsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
$login->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for loginRequest operation/method
 */
if ($login->loginRequest(new \StructType\LoginRequest()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
$logout->setSoapHeaderSession($session);
$logout->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for logoutRequest operation/method
 */
if ($logout->logoutRequest(new \StructType\LogoutRequest()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ServiceType\Mark($options);
$mark->setSoapHeaderSession($session);
$mark->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for markPrivateRequest operation/method
 */
if ($mark->markPrivateRequest(new \StructType\MarkPrivateRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markReadRequest operation/method
 */
if ($mark->markReadRequest(new \StructType\MarkReadRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markUnPrivateRequest operation/method
 */
if ($mark->markUnPrivateRequest(new \StructType\MarkUnPrivateRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Sample call for markUnReadRequest operation/method
 */
if ($mark->markUnReadRequest(new \StructType\MarkUnReadRequest()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
$modify->setSoapHeaderSession($session);
$modify->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for modifyItemRequest operation/method
 */
if ($modify->modifyItemRequest(new \StructType\ModifyItemRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyItemsRequest operation/method
 */
if ($modify->modifyItemsRequest(new \StructType\ModifyItemsRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyJunkEntryRequest operation/method
 */
if ($modify->modifyJunkEntryRequest(new \StructType\ModifyJunkEntryRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyJunkMailSettingsRequest operation/method
 */
if ($modify->modifyJunkMailSettingsRequest(new \StructType\ModifyJunkMailSettingsRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyNotifyRequest operation/method
 */
if ($modify->modifyNotifyRequest(new \StructType\ModifyNotifyRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyPasswordRequest operation/method
 */
if ($modify->modifyPasswordRequest(new \StructType\ModifyPasswordRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyProxyAccessRequest operation/method
 */
if ($modify->modifyProxyAccessRequest(new \StructType\ModifyProxyAccessRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifySettingsRequest operation/method
 */
if ($modify->modifySettingsRequest(new \StructType\ModifySettingsRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifySignaturesRequest operation/method
 */
if ($modify->modifySignaturesRequest(new \StructType\ModifySignaturesRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \ServiceType\Move($options);
$move->setSoapHeaderSession($session);
$move->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for moveItemRequest operation/method
 */
if ($move->moveItemRequest(new \StructType\MoveItemRequest()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveItemsRequest operation/method
 */
if ($move->moveItemsRequest(new \StructType\MoveItemsRequest()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Poll ServiceType
 */
$poll = new \ServiceType\Poll($options);
$poll->setSoapHeaderSession($session);
$poll->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for pollRequest operation/method
 */
if ($poll->pollRequest(new \StructType\PollRequest()) !== false) {
    print_r($poll->getResult());
} else {
    print_r($poll->getLastError());
}
/**
 * Samples for Position ServiceType
 */
$position = new \ServiceType\Position($options);
$position->setSoapHeaderSession($session);
$position->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for positionCursorRequest operation/method
 */
if ($position->positionCursorRequest(new \StructType\PositionCursorRequest()) !== false) {
    print_r($position->getResult());
} else {
    print_r($position->getLastError());
}
/**
 * Samples for Purge ServiceType
 */
$purge = new \ServiceType\Purge($options);
$purge->setSoapHeaderSession($session);
$purge->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for purgeDeletedItemsRequest operation/method
 */
if ($purge->purgeDeletedItemsRequest(new \StructType\PurgeDeletedItemsRequest()) !== false) {
    print_r($purge->getResult());
} else {
    print_r($purge->getLastError());
}
/**
 * Sample call for purgeRequest operation/method
 */
if ($purge->purgeRequest(new \StructType\PurgeRequest()) !== false) {
    print_r($purge->getResult());
} else {
    print_r($purge->getLastError());
}
/**
 * Samples for Read ServiceType
 */
$read = new \ServiceType\Read($options);
$read->setSoapHeaderSession($session);
$read->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for readCursorRequest operation/method
 */
if ($read->readCursorRequest(new \StructType\ReadCursorRequest()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
$remove->setSoapHeaderSession($session);
$remove->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for removeCustomDefinitionRequest operation/method
 */
if ($remove->removeCustomDefinitionRequest(new \StructType\RemoveCustomDefinitionRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeItemRequest operation/method
 */
if ($remove->removeItemRequest(new \StructType\RemoveItemRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeItemsRequest operation/method
 */
if ($remove->removeItemsRequest(new \StructType\RemoveItemsRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeJunkEntryRequest operation/method
 */
if ($remove->removeJunkEntryRequest(new \StructType\RemoveJunkEntryRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMembersRequest operation/method
 */
if ($remove->removeMembersRequest(new \StructType\RemoveMembersRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeNotifyRequest operation/method
 */
if ($remove->removeNotifyRequest(new \StructType\RemoveNotifyRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeProxyAccessRequest operation/method
 */
if ($remove->removeProxyAccessRequest(new \StructType\RemoveProxyAccessRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeProxyUserRequest operation/method
 */
if ($remove->removeProxyUserRequest(new \StructType\RemoveProxyUserRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSignatureRequest operation/method
 */
if ($remove->removeSignatureRequest(new \StructType\RemoveSignatureRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeEventConfigurationRequest operation/method
 */
if ($remove->removeEventConfigurationRequest(new \StructType\RemoveEventConfigurationRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeEventsRequest operation/method
 */
if ($remove->removeEventsRequest(new \StructType\RemoveEventsRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Reply ServiceType
 */
$reply = new \ServiceType\Reply($options);
$reply->setSoapHeaderSession($session);
$reply->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for replyRequest operation/method
 */
if ($reply->replyRequest(new \StructType\ReplyRequest()) !== false) {
    print_r($reply->getResult());
} else {
    print_r($reply->getLastError());
}
/**
 * Samples for Resend ServiceType
 */
$resend = new \ServiceType\Resend($options);
$resend->setSoapHeaderSession($session);
$resend->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for resendRequest operation/method
 */
if ($resend->resendRequest(new \StructType\ResendRequest()) !== false) {
    print_r($resend->getResult());
} else {
    print_r($resend->getLastError());
}
/**
 * Samples for Resolve ServiceType
 */
$resolve = new \ServiceType\Resolve($options);
$resolve->setSoapHeaderSession($session);
$resolve->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for resolveRequest operation/method
 */
if ($resolve->resolveRequest(new \StructType\ResolveRequest()) !== false) {
    print_r($resolve->getResult());
} else {
    print_r($resolve->getLastError());
}
/**
 * Samples for Restore ServiceType
 */
$restore = new \ServiceType\Restore($options);
$restore->setSoapHeaderSession($session);
$restore->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for restoreItemRequest operation/method
 */
if ($restore->restoreItemRequest(new \StructType\RestoreItemRequest()) !== false) {
    print_r($restore->getResult());
} else {
    print_r($restore->getLastError());
}
/**
 * Samples for Retract ServiceType
 */
$retract = new \ServiceType\Retract($options);
$retract->setSoapHeaderSession($session);
$retract->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for retractRequest operation/method
 */
if ($retract->retractRequest(new \StructType\RetractRequest()) !== false) {
    print_r($retract->getResult());
} else {
    print_r($retract->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
$send->setSoapHeaderSession($session);
$send->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for sendItemRequest operation/method
 */
if ($send->sendItemRequest(new \StructType\SendItemRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderSession($session);
$set->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for setTimestampRequest operation/method
 */
if ($set->setTimestampRequest(new \StructType\SetTimestampRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Start ServiceType
 */
$start = new \ServiceType\Start($options);
$start->setSoapHeaderSession($session);
$start->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for startFreeBusySessionRequest operation/method
 */
if ($start->startFreeBusySessionRequest(new \StructType\StartFreeBusySessionRequest()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Samples for Streamed ServiceType
 */
$streamed = new \ServiceType\Streamed($options);
$streamed->setSoapHeaderSession($session);
$streamed->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for streamedSearchRequest operation/method
 */
if ($streamed->streamedSearchRequest(new \StructType\StreamedSearchRequest()) !== false) {
    print_r($streamed->getResult());
} else {
    print_r($streamed->getLastError());
}
/**
 * Samples for Stub ServiceType
 */
$stub = new \ServiceType\Stub($options);
$stub->setSoapHeaderSession($session);
$stub->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for stubItemRequest operation/method
 */
if ($stub->stubItemRequest(new \StructType\StubItemRequest()) !== false) {
    print_r($stub->getResult());
} else {
    print_r($stub->getLastError());
}
/**
 * Samples for Unaccept ServiceType
 */
$unaccept = new \ServiceType\Unaccept($options);
$unaccept->setSoapHeaderSession($session);
$unaccept->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for unacceptRequest operation/method
 */
if ($unaccept->unacceptRequest(new \StructType\UnacceptRequest()) !== false) {
    print_r($unaccept->getResult());
} else {
    print_r($unaccept->getLastError());
}
/**
 * Samples for Uncomplete ServiceType
 */
$uncomplete = new \ServiceType\Uncomplete($options);
$uncomplete->setSoapHeaderSession($session);
$uncomplete->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for uncompleteRequest operation/method
 */
if ($uncomplete->uncompleteRequest(new \StructType\UncompleteRequest()) !== false) {
    print_r($uncomplete->getResult());
} else {
    print_r($uncomplete->getLastError());
}
/**
 * Samples for Unarchive ServiceType
 */
$unarchive = new \ServiceType\Unarchive($options);
$unarchive->setSoapHeaderSession($session);
$unarchive->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for unarchiveRequest operation/method
 */
if ($unarchive->unarchiveRequest(new \StructType\UnarchiveRequest()) !== false) {
    print_r($unarchive->getResult());
} else {
    print_r($unarchive->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderSession($session);
$update->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for updateVersionStatusRequest operation/method
 */
if ($update->updateVersionStatusRequest(new \StructType\UpdateVersionStatusRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Clean ServiceType
 */
$clean = new \ServiceType\Clean($options);
$clean->setSoapHeaderSession($session);
$clean->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for cleanEventConfigurationRequest operation/method
 */
if ($clean->cleanEventConfigurationRequest(new \StructType\CleanEventConfigurationRequest()) !== false) {
    print_r($clean->getResult());
} else {
    print_r($clean->getLastError());
}
/**
 * Samples for Configure ServiceType
 */
$configure = new \ServiceType\Configure($options);
$configure->setSoapHeaderSession($session);
$configure->setSoapHeaderGwTrace($gwTrace);
/**
 * Sample call for configureEventsRequest operation/method
 */
if ($configure->configureEventsRequest(new \StructType\ConfigureEventsRequest()) !== false) {
    print_r($configure->getResult());
} else {
    print_r($configure->getLastError());
}
