<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionEvent StructType
 * @subpackage Structs
 */
class VersionEvent extends ContainerItem
{
    /**
     * The library
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $library;
    /**
     * The documentNumber
     * @var int
     */
    public $documentNumber;
    /**
     * The versionNumber
     * @var int
     */
    public $versionNumber;
    /**
     * The creator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $creator;
    /**
     * The event
     * @var string
     */
    public $event;
    /**
     * The eventNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $eventNumber;
    /**
     * The filename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filename;
    /**
     * Constructor method for VersionEvent
     * @uses VersionEvent::setLibrary()
     * @uses VersionEvent::setDocumentNumber()
     * @uses VersionEvent::setVersionNumber()
     * @uses VersionEvent::setCreator()
     * @uses VersionEvent::setEvent()
     * @uses VersionEvent::setEventNumber()
     * @uses VersionEvent::setFilename()
     * @param \StructType\NameAndEmail $library
     * @param int $documentNumber
     * @param int $versionNumber
     * @param \StructType\NameAndEmail $creator
     * @param string $event
     * @param int $eventNumber
     * @param string $filename
     */
    public function __construct(\StructType\NameAndEmail $library = null, $documentNumber = null, $versionNumber = null, \StructType\NameAndEmail $creator = null, $event = null, $eventNumber = null, $filename = null)
    {
        $this
            ->setLibrary($library)
            ->setDocumentNumber($documentNumber)
            ->setVersionNumber($versionNumber)
            ->setCreator($creator)
            ->setEvent($event)
            ->setEventNumber($eventNumber)
            ->setFilename($filename);
    }
    /**
     * Get library value
     * @return \StructType\NameAndEmail|null
     */
    public function getLibrary()
    {
        return $this->library;
    }
    /**
     * Set library value
     * @param \StructType\NameAndEmail $library
     * @return \StructType\VersionEvent
     */
    public function setLibrary(\StructType\NameAndEmail $library = null)
    {
        $this->library = $library;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return int|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param int $documentNumber
     * @return \StructType\VersionEvent
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($documentNumber) && !is_numeric($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get versionNumber value
     * @return int|null
     */
    public function getVersionNumber()
    {
        return $this->versionNumber;
    }
    /**
     * Set versionNumber value
     * @param int $versionNumber
     * @return \StructType\VersionEvent
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !is_numeric($versionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($versionNumber)), __LINE__);
        }
        $this->versionNumber = $versionNumber;
        return $this;
    }
    /**
     * Get creator value
     * @return \StructType\NameAndEmail|null
     */
    public function getCreator()
    {
        return $this->creator;
    }
    /**
     * Set creator value
     * @param \StructType\NameAndEmail $creator
     * @return \StructType\VersionEvent
     */
    public function setCreator(\StructType\NameAndEmail $creator = null)
    {
        $this->creator = $creator;
        return $this;
    }
    /**
     * Get event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @uses \EnumType\VersionEventType::valueIsValid()
     * @uses \EnumType\VersionEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $event
     * @return \StructType\VersionEvent
     */
    public function setEvent($event = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VersionEventType::valueIsValid($event)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $event, implode(', ', \EnumType\VersionEventType::getValidValues())), __LINE__);
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Get eventNumber value
     * @return int|null
     */
    public function getEventNumber()
    {
        return $this->eventNumber;
    }
    /**
     * Set eventNumber value
     * @param int $eventNumber
     * @return \StructType\VersionEvent
     */
    public function setEventNumber($eventNumber = null)
    {
        // validation for constraint: int
        if (!is_null($eventNumber) && !is_numeric($eventNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eventNumber)), __LINE__);
        }
        $this->eventNumber = $eventNumber;
        return $this;
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\VersionEvent
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VersionEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
