<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserList StructType
 * @subpackage Structs
 */
class UserList extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserInfo[]
     */
    public $user;
    /**
     * Constructor method for UserList
     * @uses UserList::setUser()
     * @param \StructType\UserInfo[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get user value
     * @return \StructType\UserInfo[]|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo[] $user
     * @return \StructType\UserList
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $userListUserItem) {
            // validation for constraint: itemType
            if (!$userListUserItem instanceof \StructType\UserInfo) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\UserInfo, "%s" given', is_object($userListUserItem) ? get_class($userListUserItem) : gettype($userListUserItem)), __LINE__);
            }
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo $item
     * @return \StructType\UserList
     */
    public function addToUser(\StructType\UserInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserInfo) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\UserInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
