<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for unarchiveRequest StructType
 * @subpackage Structs
 */
class UnarchiveRequest extends AbstractStructBase
{
    /**
     * The items
     * @var \StructType\ItemRefList
     */
    public $items;
    /**
     * The path
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $path;
    /**
     * Constructor method for unarchiveRequest
     * @uses UnarchiveRequest::setItems()
     * @uses UnarchiveRequest::setPath()
     * @param \StructType\ItemRefList $items
     * @param string $path
     */
    public function __construct(\StructType\ItemRefList $items = null, $path = null)
    {
        $this
            ->setItems($items)
            ->setPath($path);
    }
    /**
     * Get items value
     * @return \StructType\ItemRefList|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \StructType\ItemRefList $items
     * @return \StructType\UnarchiveRequest
     */
    public function setItems(\StructType\ItemRefList $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->path;
    }
    /**
     * Set path value
     * @param string $path
     * @return \StructType\UnarchiveRequest
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($path)), __LINE__);
        }
        $this->path = $path;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnarchiveRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
