<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrustedApplication StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:boolean
 * @subpackage Structs
 */
class TrustedApplication extends Authentication
{
    /**
     * The proxy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $proxy;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The key
     * @var string
     */
    public $key;
    /**
     * Constructor method for TrustedApplication
     * @uses TrustedApplication::setProxy()
     * @uses TrustedApplication::setName()
     * @uses TrustedApplication::setKey()
     * @param string $proxy
     * @param string $name
     * @param string $key
     */
    public function __construct($proxy = null, $name = null, $key = null)
    {
        $this
            ->setProxy($proxy)
            ->setName($name)
            ->setKey($key);
    }
    /**
     * Get proxy value
     * @return string|null
     */
    public function getProxy()
    {
        return $this->proxy;
    }
    /**
     * Set proxy value
     * @param string $proxy
     * @return \StructType\TrustedApplication
     */
    public function setProxy($proxy = null)
    {
        // validation for constraint: string
        if (!is_null($proxy) && !is_string($proxy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxy)), __LINE__);
        }
        $this->proxy = $proxy;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\TrustedApplication
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\TrustedApplication
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrustedApplication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
