<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimezoneList StructType
 * @subpackage Structs
 */
class TimezoneList extends AbstractStructBase
{
    /**
     * The timezone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Timezone[]
     */
    public $timezone;
    /**
     * Constructor method for TimezoneList
     * @uses TimezoneList::setTimezone()
     * @param \StructType\Timezone[] $timezone
     */
    public function __construct(array $timezone = array())
    {
        $this
            ->setTimezone($timezone);
    }
    /**
     * Get timezone value
     * @return \StructType\Timezone[]|null
     */
    public function getTimezone()
    {
        return $this->timezone;
    }
    /**
     * Set timezone value
     * @throws \InvalidArgumentException
     * @param \StructType\Timezone[] $timezone
     * @return \StructType\TimezoneList
     */
    public function setTimezone(array $timezone = array())
    {
        foreach ($timezone as $timezoneListTimezoneItem) {
            // validation for constraint: itemType
            if (!$timezoneListTimezoneItem instanceof \StructType\Timezone) {
                throw new \InvalidArgumentException(sprintf('The timezone property can only contain items of \StructType\Timezone, "%s" given', is_object($timezoneListTimezoneItem) ? get_class($timezoneListTimezoneItem) : gettype($timezoneListTimezoneItem)), __LINE__);
            }
        }
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Add item to timezone value
     * @throws \InvalidArgumentException
     * @param \StructType\Timezone $item
     * @return \StructType\TimezoneList
     */
    public function addToTimezone(\StructType\Timezone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Timezone) {
            throw new \InvalidArgumentException(sprintf('The timezone property can only contain items of \StructType\Timezone, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->timezone[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TimezoneList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
