<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for streamedSearchResponse StructType
 * @subpackage Structs
 */
class StreamedSearchResponse extends AbstractStructBase
{
    /**
     * The items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Items
     */
    public $items;
    /**
     * The lastHitId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastHitId;
    /**
     * The status
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for streamedSearchResponse
     * @uses StreamedSearchResponse::setItems()
     * @uses StreamedSearchResponse::setLastHitId()
     * @uses StreamedSearchResponse::setStatus()
     * @param \StructType\Items $items
     * @param string $lastHitId
     * @param \StructType\Status $status
     */
    public function __construct(\StructType\Items $items = null, $lastHitId = null, \StructType\Status $status = null)
    {
        $this
            ->setItems($items)
            ->setLastHitId($lastHitId)
            ->setStatus($status);
    }
    /**
     * Get items value
     * @return \StructType\Items|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \StructType\Items $items
     * @return \StructType\StreamedSearchResponse
     */
    public function setItems(\StructType\Items $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get lastHitId value
     * @return string|null
     */
    public function getLastHitId()
    {
        return $this->lastHitId;
    }
    /**
     * Set lastHitId value
     * @param string $lastHitId
     * @return \StructType\StreamedSearchResponse
     */
    public function setLastHitId($lastHitId = null)
    {
        // validation for constraint: string
        if (!is_null($lastHitId) && !is_string($lastHitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastHitId)), __LINE__);
        }
        $this->lastHitId = $lastHitId;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\StreamedSearchResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StreamedSearchResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
