<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Signatures StructType
 * @subpackage Structs
 */
class Signatures extends AbstractStructBase
{
    /**
     * The signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Signature[]
     */
    public $signature;
    /**
     * The setting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SignatureSettings
     */
    public $setting;
    /**
     * Constructor method for Signatures
     * @uses Signatures::setSignature()
     * @uses Signatures::setSetting()
     * @param \StructType\Signature[] $signature
     * @param \StructType\SignatureSettings $setting
     */
    public function __construct(array $signature = array(), \StructType\SignatureSettings $setting = null)
    {
        $this
            ->setSignature($signature)
            ->setSetting($setting);
    }
    /**
     * Get signature value
     * @return \StructType\Signature[]|null
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * Set signature value
     * @throws \InvalidArgumentException
     * @param \StructType\Signature[] $signature
     * @return \StructType\Signatures
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $signaturesSignatureItem) {
            // validation for constraint: itemType
            if (!$signaturesSignatureItem instanceof \StructType\Signature) {
                throw new \InvalidArgumentException(sprintf('The signature property can only contain items of \StructType\Signature, "%s" given', is_object($signaturesSignatureItem) ? get_class($signaturesSignatureItem) : gettype($signaturesSignatureItem)), __LINE__);
            }
        }
        $this->signature = $signature;
        return $this;
    }
    /**
     * Add item to signature value
     * @throws \InvalidArgumentException
     * @param \StructType\Signature $item
     * @return \StructType\Signatures
     */
    public function addToSignature(\StructType\Signature $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Signature) {
            throw new \InvalidArgumentException(sprintf('The signature property can only contain items of \StructType\Signature, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->signature[] = $item;
        return $this;
    }
    /**
     * Get setting value
     * @return \StructType\SignatureSettings|null
     */
    public function getSetting()
    {
        return $this->setting;
    }
    /**
     * Set setting value
     * @param \StructType\SignatureSettings $setting
     * @return \StructType\Signatures
     */
    public function setSetting(\StructType\SignatureSettings $setting = null)
    {
        $this->setting = $setting;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Signatures
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
