<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Signature StructType
 * @subpackage Structs
 */
class Signature extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:name
     * @var string
     */
    public $name;
    /**
     * The default
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var bool
     */
    public $default;
    /**
     * The part
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SignatureData
     */
    public $part;
    /**
     * The global
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var bool
     */
    public $global;
    /**
     * Constructor method for Signature
     * @uses Signature::setId()
     * @uses Signature::setName()
     * @uses Signature::setDefault()
     * @uses Signature::setPart()
     * @uses Signature::setGlobal()
     * @param string $id
     * @param string $name
     * @param bool $default
     * @param \StructType\SignatureData $part
     * @param bool $global
     */
    public function __construct($id = null, $name = null, $default = false, \StructType\SignatureData $part = null, $global = false)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setDefault($default)
            ->setPart($part)
            ->setGlobal($global);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Signature
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Signature
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get default value
     * @return bool|null
     */
    public function getDefault()
    {
        return $this->default;
    }
    /**
     * Set default value
     * @param bool $default
     * @return \StructType\Signature
     */
    public function setDefault($default = false)
    {
        // validation for constraint: boolean
        if (!is_null($default) && !is_bool($default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($default)), __LINE__);
        }
        $this->default = $default;
        return $this;
    }
    /**
     * Get part value
     * @return \StructType\SignatureData|null
     */
    public function getPart()
    {
        return $this->part;
    }
    /**
     * Set part value
     * @param \StructType\SignatureData $part
     * @return \StructType\Signature
     */
    public function setPart(\StructType\SignatureData $part = null)
    {
        $this->part = $part;
        return $this;
    }
    /**
     * Get global value
     * @return bool|null
     */
    public function getGlobal()
    {
        return $this->global;
    }
    /**
     * Set global value
     * @param bool $global
     * @return \StructType\Signature
     */
    public function setGlobal($global = false)
    {
        // validation for constraint: boolean
        if (!is_null($global) && !is_bool($global)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($global)), __LINE__);
        }
        $this->global = $global;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Signature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
