<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SharedNotification StructType
 * @subpackage Structs
 */
class SharedNotification extends Mail
{
    /**
     * The notification
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $notification;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * The rights
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:rights
     * @var \StructType\Rights
     */
    public $rights;
    /**
     * Constructor method for SharedNotification
     * @uses SharedNotification::setNotification()
     * @uses SharedNotification::setDescription()
     * @uses SharedNotification::setRights()
     * @param string $notification
     * @param string $description
     * @param \StructType\Rights $rights
     */
    public function __construct($notification = null, $description = null, \StructType\Rights $rights = null)
    {
        $this
            ->setNotification($notification)
            ->setDescription($description)
            ->setRights($rights);
    }
    /**
     * Get notification value
     * @return string
     */
    public function getNotification()
    {
        return $this->notification;
    }
    /**
     * Set notification value
     * @uses \EnumType\NotificationType::valueIsValid()
     * @uses \EnumType\NotificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notification
     * @return \StructType\SharedNotification
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NotificationType::valueIsValid($notification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $notification, implode(', ', \EnumType\NotificationType::getValidValues())), __LINE__);
        }
        $this->notification = $notification;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SharedNotification
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get rights value
     * @return \StructType\Rights|null
     */
    public function getRights()
    {
        return $this->rights;
    }
    /**
     * Set rights value
     * @param \StructType\Rights $rights
     * @return \StructType\SharedNotification
     */
    public function setRights(\StructType\Rights $rights = null)
    {
        $this->rights = $rights;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SharedNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
