<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SharedFolder StructType
 * Meta informations extracted from the WSDL
 * - type: tns:UUID
 * @subpackage Structs
 */
class SharedFolder extends Folder
{
    /**
     * The rights
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:rights
     * @var \StructType\Rights
     */
    public $rights;
    /**
     * The acl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FolderACL
     */
    public $acl;
    /**
     * The owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $owner;
    /**
     * The isSharedByMe
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSharedByMe;
    /**
     * The isSharedToMe
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isSharedToMe;
    /**
     * Constructor method for SharedFolder
     * @uses SharedFolder::setRights()
     * @uses SharedFolder::setAcl()
     * @uses SharedFolder::setOwner()
     * @uses SharedFolder::setIsSharedByMe()
     * @uses SharedFolder::setIsSharedToMe()
     * @param \StructType\Rights $rights
     * @param \StructType\FolderACL $acl
     * @param \StructType\NameAndEmail $owner
     * @param bool $isSharedByMe
     * @param bool $isSharedToMe
     */
    public function __construct(\StructType\Rights $rights = null, \StructType\FolderACL $acl = null, \StructType\NameAndEmail $owner = null, $isSharedByMe = null, $isSharedToMe = null)
    {
        $this
            ->setRights($rights)
            ->setAcl($acl)
            ->setOwner($owner)
            ->setIsSharedByMe($isSharedByMe)
            ->setIsSharedToMe($isSharedToMe);
    }
    /**
     * Get rights value
     * @return \StructType\Rights|null
     */
    public function getRights()
    {
        return $this->rights;
    }
    /**
     * Set rights value
     * @param \StructType\Rights $rights
     * @return \StructType\SharedFolder
     */
    public function setRights(\StructType\Rights $rights = null)
    {
        $this->rights = $rights;
        return $this;
    }
    /**
     * Get acl value
     * @return \StructType\FolderACL|null
     */
    public function getAcl()
    {
        return $this->acl;
    }
    /**
     * Set acl value
     * @param \StructType\FolderACL $acl
     * @return \StructType\SharedFolder
     */
    public function setAcl(\StructType\FolderACL $acl = null)
    {
        $this->acl = $acl;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\NameAndEmail|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\NameAndEmail $owner
     * @return \StructType\SharedFolder
     */
    public function setOwner(\StructType\NameAndEmail $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get isSharedByMe value
     * @return bool|null
     */
    public function getIsSharedByMe()
    {
        return $this->isSharedByMe;
    }
    /**
     * Set isSharedByMe value
     * @param bool $isSharedByMe
     * @return \StructType\SharedFolder
     */
    public function setIsSharedByMe($isSharedByMe = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSharedByMe) && !is_bool($isSharedByMe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSharedByMe)), __LINE__);
        }
        $this->isSharedByMe = $isSharedByMe;
        return $this;
    }
    /**
     * Get isSharedToMe value
     * @return bool|null
     */
    public function getIsSharedToMe()
    {
        return $this->isSharedToMe;
    }
    /**
     * Set isSharedToMe value
     * @param bool $isSharedToMe
     * @return \StructType\SharedFolder
     */
    public function setIsSharedToMe($isSharedToMe = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSharedToMe) && !is_bool($isSharedToMe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSharedToMe)), __LINE__);
        }
        $this->isSharedToMe = $isSharedToMe;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SharedFolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
