<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setTimestampRequest StructType
 * @subpackage Structs
 */
class SetTimestampRequest extends AbstractStructBase
{
    /**
     * The backup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $backup;
    /**
     * The retention
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $retention;
    /**
     * The retentionModified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $retentionModified;
    /**
     * Constructor method for setTimestampRequest
     * @uses SetTimestampRequest::setBackup()
     * @uses SetTimestampRequest::setRetention()
     * @uses SetTimestampRequest::setRetentionModified()
     * @param string $backup
     * @param string $retention
     * @param string $retentionModified
     */
    public function __construct($backup = null, $retention = null, $retentionModified = null)
    {
        $this
            ->setBackup($backup)
            ->setRetention($retention)
            ->setRetentionModified($retentionModified);
    }
    /**
     * Get backup value
     * @return string|null
     */
    public function getBackup()
    {
        return $this->backup;
    }
    /**
     * Set backup value
     * @param string $backup
     * @return \StructType\SetTimestampRequest
     */
    public function setBackup($backup = null)
    {
        // validation for constraint: string
        if (!is_null($backup) && !is_string($backup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($backup)), __LINE__);
        }
        $this->backup = $backup;
        return $this;
    }
    /**
     * Get retention value
     * @return string|null
     */
    public function getRetention()
    {
        return $this->retention;
    }
    /**
     * Set retention value
     * @param string $retention
     * @return \StructType\SetTimestampRequest
     */
    public function setRetention($retention = null)
    {
        // validation for constraint: string
        if (!is_null($retention) && !is_string($retention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retention)), __LINE__);
        }
        $this->retention = $retention;
        return $this;
    }
    /**
     * Get retentionModified value
     * @return string|null
     */
    public function getRetentionModified()
    {
        return $this->retentionModified;
    }
    /**
     * Set retentionModified value
     * @param string $retentionModified
     * @return \StructType\SetTimestampRequest
     */
    public function setRetentionModified($retentionModified = null)
    {
        // validation for constraint: string
        if (!is_null($retentionModified) && !is_string($retentionModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retentionModified)), __LINE__);
        }
        $this->retentionModified = $retentionModified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetTimestampRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
