<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendItemRequest StructType
 * @subpackage Structs
 */
class SendItemRequest extends AbstractStructBase
{
    /**
     * The item
     * @var \StructType\Item
     */
    public $item;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $view;
    /**
     * Constructor method for sendItemRequest
     * @uses SendItemRequest::setItem()
     * @uses SendItemRequest::setView()
     * @param \StructType\Item $item
     * @param string $view
     */
    public function __construct(\StructType\Item $item = null, $view = null)
    {
        $this
            ->setItem($item)
            ->setView($view);
    }
    /**
     * Get item value
     * @return \StructType\Item|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\Item $item
     * @return \StructType\SendItemRequest
     */
    public function setItem(\StructType\Item $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\SendItemRequest
     */
    public function setView($view = null)
    {
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
