<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SMimeOperation StructType
 * @subpackage Structs
 */
class SMimeOperation extends AbstractStructBase
{
    /**
     * The signed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $signed;
    /**
     * The encrypted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $encrypted;
    /**
     * Constructor method for SMimeOperation
     * @uses SMimeOperation::setSigned()
     * @uses SMimeOperation::setEncrypted()
     * @param bool $signed
     * @param bool $encrypted
     */
    public function __construct($signed = null, $encrypted = null)
    {
        $this
            ->setSigned($signed)
            ->setEncrypted($encrypted);
    }
    /**
     * Get signed value
     * @return bool|null
     */
    public function getSigned()
    {
        return $this->signed;
    }
    /**
     * Set signed value
     * @param bool $signed
     * @return \StructType\SMimeOperation
     */
    public function setSigned($signed = null)
    {
        // validation for constraint: boolean
        if (!is_null($signed) && !is_bool($signed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($signed)), __LINE__);
        }
        $this->signed = $signed;
        return $this;
    }
    /**
     * Get encrypted value
     * @return bool|null
     */
    public function getEncrypted()
    {
        return $this->encrypted;
    }
    /**
     * Set encrypted value
     * @param bool $encrypted
     * @return \StructType\SMimeOperation
     */
    public function setEncrypted($encrypted = null)
    {
        // validation for constraint: boolean
        if (!is_null($encrypted) && !is_bool($encrypted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($encrypted)), __LINE__);
        }
        $this->encrypted = $encrypted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SMimeOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
