<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleList StructType
 * @subpackage Structs
 */
class RuleList extends AbstractStructBase
{
    /**
     * The rule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Rule[]
     */
    public $rule;
    /**
     * Constructor method for RuleList
     * @uses RuleList::setRule()
     * @param \StructType\Rule[] $rule
     */
    public function __construct(array $rule = array())
    {
        $this
            ->setRule($rule);
    }
    /**
     * Get rule value
     * @return \StructType\Rule[]|null
     */
    public function getRule()
    {
        return $this->rule;
    }
    /**
     * Set rule value
     * @throws \InvalidArgumentException
     * @param \StructType\Rule[] $rule
     * @return \StructType\RuleList
     */
    public function setRule(array $rule = array())
    {
        foreach ($rule as $ruleListRuleItem) {
            // validation for constraint: itemType
            if (!$ruleListRuleItem instanceof \StructType\Rule) {
                throw new \InvalidArgumentException(sprintf('The rule property can only contain items of \StructType\Rule, "%s" given', is_object($ruleListRuleItem) ? get_class($ruleListRuleItem) : gettype($ruleListRuleItem)), __LINE__);
            }
        }
        $this->rule = $rule;
        return $this;
    }
    /**
     * Add item to rule value
     * @throws \InvalidArgumentException
     * @param \StructType\Rule $item
     * @return \StructType\RuleList
     */
    public function addToRule(\StructType\Rule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rule) {
            throw new \InvalidArgumentException(sprintf('The rule property can only contain items of \StructType\Rule, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RuleList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
