<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnNotification StructType
 * Meta informations extracted from the WSDL
 * - documentation: A calendar item will have opened, accepted and declined (not deleted) A box entry item will have opened and deleted
 * @subpackage Structs
 */
class ReturnNotification extends AbstractStructBase
{
    /**
     * The opened
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnNotificationOptions
     */
    public $opened;
    /**
     * The deleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnNotificationOptions
     */
    public $deleted;
    /**
     * The accepted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnNotificationOptions
     */
    public $accepted;
    /**
     * The declined
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnNotificationOptions
     */
    public $declined;
    /**
     * The completed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnNotificationOptions
     */
    public $completed;
    /**
     * Constructor method for ReturnNotification
     * @uses ReturnNotification::setOpened()
     * @uses ReturnNotification::setDeleted()
     * @uses ReturnNotification::setAccepted()
     * @uses ReturnNotification::setDeclined()
     * @uses ReturnNotification::setCompleted()
     * @param \StructType\ReturnNotificationOptions $opened
     * @param \StructType\ReturnNotificationOptions $deleted
     * @param \StructType\ReturnNotificationOptions $accepted
     * @param \StructType\ReturnNotificationOptions $declined
     * @param \StructType\ReturnNotificationOptions $completed
     */
    public function __construct(\StructType\ReturnNotificationOptions $opened = null, \StructType\ReturnNotificationOptions $deleted = null, \StructType\ReturnNotificationOptions $accepted = null, \StructType\ReturnNotificationOptions $declined = null, \StructType\ReturnNotificationOptions $completed = null)
    {
        $this
            ->setOpened($opened)
            ->setDeleted($deleted)
            ->setAccepted($accepted)
            ->setDeclined($declined)
            ->setCompleted($completed);
    }
    /**
     * Get opened value
     * @return \StructType\ReturnNotificationOptions|null
     */
    public function getOpened()
    {
        return $this->opened;
    }
    /**
     * Set opened value
     * @param \StructType\ReturnNotificationOptions $opened
     * @return \StructType\ReturnNotification
     */
    public function setOpened(\StructType\ReturnNotificationOptions $opened = null)
    {
        $this->opened = $opened;
        return $this;
    }
    /**
     * Get deleted value
     * @return \StructType\ReturnNotificationOptions|null
     */
    public function getDeleted()
    {
        return $this->deleted;
    }
    /**
     * Set deleted value
     * @param \StructType\ReturnNotificationOptions $deleted
     * @return \StructType\ReturnNotification
     */
    public function setDeleted(\StructType\ReturnNotificationOptions $deleted = null)
    {
        $this->deleted = $deleted;
        return $this;
    }
    /**
     * Get accepted value
     * @return \StructType\ReturnNotificationOptions|null
     */
    public function getAccepted()
    {
        return $this->accepted;
    }
    /**
     * Set accepted value
     * @param \StructType\ReturnNotificationOptions $accepted
     * @return \StructType\ReturnNotification
     */
    public function setAccepted(\StructType\ReturnNotificationOptions $accepted = null)
    {
        $this->accepted = $accepted;
        return $this;
    }
    /**
     * Get declined value
     * @return \StructType\ReturnNotificationOptions|null
     */
    public function getDeclined()
    {
        return $this->declined;
    }
    /**
     * Set declined value
     * @param \StructType\ReturnNotificationOptions $declined
     * @return \StructType\ReturnNotification
     */
    public function setDeclined(\StructType\ReturnNotificationOptions $declined = null)
    {
        $this->declined = $declined;
        return $this;
    }
    /**
     * Get completed value
     * @return \StructType\ReturnNotificationOptions|null
     */
    public function getCompleted()
    {
        return $this->completed;
    }
    /**
     * Set completed value
     * @param \StructType\ReturnNotificationOptions $completed
     * @return \StructType\ReturnNotification
     */
    public function setCompleted(\StructType\ReturnNotificationOptions $completed = null)
    {
        $this->completed = $completed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReturnNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
