<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: tns:ResourceFlags
 * @subpackage Structs
 */
class Resource extends AddressBookItem
{
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The resourceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resourceType;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:email
     * @var string
     */
    public $email;
    /**
     * The owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemRef
     */
    public $owner;
    /**
     * Constructor method for Resource
     * @uses Resource::setPhone()
     * @uses Resource::setResourceType()
     * @uses Resource::setEmail()
     * @uses Resource::setOwner()
     * @param string $phone
     * @param string $resourceType
     * @param string $email
     * @param \StructType\ItemRef $owner
     */
    public function __construct($phone = null, $resourceType = null, $email = null, \StructType\ItemRef $owner = null)
    {
        $this
            ->setPhone($phone)
            ->setResourceType($resourceType)
            ->setEmail($email)
            ->setOwner($owner);
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Resource
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get resourceType value
     * @return string|null
     */
    public function getResourceType()
    {
        return $this->resourceType;
    }
    /**
     * Set resourceType value
     * @param string $resourceType
     * @return \StructType\Resource
     */
    public function setResourceType($resourceType = null)
    {
        // validation for constraint: string
        if (!is_null($resourceType) && !is_string($resourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resourceType)), __LINE__);
        }
        $this->resourceType = $resourceType;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Resource
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\ItemRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\ItemRef $owner
     * @return \StructType\Resource
     */
    public function setOwner(\StructType\ItemRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Resource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
