<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeCustomDefinitionRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: This method remove the custom field defintion not the field and values within an item. To delete custom defintions from personal address book entries, set books = "1", else the definition will be deleted from mail items. This method
 * can take a long time to execute. You can set doAsynchronous to have the custom field definition removed in the background.
 * @subpackage Structs
 */
class RemoveCustomDefinitionRequest extends AbstractStructBase
{
    /**
     * The customs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomList
     */
    public $customs;
    /**
     * The books
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $books;
    /**
     * The doAsynchronous
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $doAsynchronous;
    /**
     * Constructor method for removeCustomDefinitionRequest
     * @uses RemoveCustomDefinitionRequest::setCustoms()
     * @uses RemoveCustomDefinitionRequest::setBooks()
     * @uses RemoveCustomDefinitionRequest::setDoAsynchronous()
     * @param \StructType\CustomList $customs
     * @param bool $books
     * @param bool $doAsynchronous
     */
    public function __construct(\StructType\CustomList $customs = null, $books = false, $doAsynchronous = false)
    {
        $this
            ->setCustoms($customs)
            ->setBooks($books)
            ->setDoAsynchronous($doAsynchronous);
    }
    /**
     * Get customs value
     * @return \StructType\CustomList|null
     */
    public function getCustoms()
    {
        return $this->customs;
    }
    /**
     * Set customs value
     * @param \StructType\CustomList $customs
     * @return \StructType\RemoveCustomDefinitionRequest
     */
    public function setCustoms(\StructType\CustomList $customs = null)
    {
        $this->customs = $customs;
        return $this;
    }
    /**
     * Get books value
     * @return bool|null
     */
    public function getBooks()
    {
        return $this->books;
    }
    /**
     * Set books value
     * @param bool $books
     * @return \StructType\RemoveCustomDefinitionRequest
     */
    public function setBooks($books = false)
    {
        // validation for constraint: boolean
        if (!is_null($books) && !is_bool($books)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($books)), __LINE__);
        }
        $this->books = $books;
        return $this;
    }
    /**
     * Get doAsynchronous value
     * @return bool|null
     */
    public function getDoAsynchronous()
    {
        return $this->doAsynchronous;
    }
    /**
     * Set doAsynchronous value
     * @param bool $doAsynchronous
     * @return \StructType\RemoveCustomDefinitionRequest
     */
    public function setDoAsynchronous($doAsynchronous = false)
    {
        // validation for constraint: boolean
        if (!is_null($doAsynchronous) && !is_bool($doAsynchronous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($doAsynchronous)), __LINE__);
        }
        $this->doAsynchronous = $doAsynchronous;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveCustomDefinitionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
