<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecurrenceRule StructType
 * Meta informations extracted from the WSDL
 * - documentation: This is the same logic as iCalendar (RFC 2445).
 * - minOccurs: 0
 * - type: xs:string
 * @subpackage Structs
 */
class RecurrenceRule extends AbstractStructBase
{
    /**
     * The frequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $frequency;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $count;
    /**
     * The until
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $until;
    /**
     * The interval
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $interval;
    /**
     * The byDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DayOfYearWeekList
     */
    public $byDay;
    /**
     * The byMonthDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DayOfMonthList
     */
    public $byMonthDay;
    /**
     * The byYearDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DayOfYearList
     */
    public $byYearDay;
    /**
     * The byMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MonthList
     */
    public $byMonth;
    /**
     * The bySetPos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DayOfYearList
     */
    public $bySetPos;
    /**
     * The honorRule
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $honorRule;
    /**
     * Constructor method for RecurrenceRule
     * @uses RecurrenceRule::setFrequency()
     * @uses RecurrenceRule::setCount()
     * @uses RecurrenceRule::setUntil()
     * @uses RecurrenceRule::setInterval()
     * @uses RecurrenceRule::setByDay()
     * @uses RecurrenceRule::setByMonthDay()
     * @uses RecurrenceRule::setByYearDay()
     * @uses RecurrenceRule::setByMonth()
     * @uses RecurrenceRule::setBySetPos()
     * @uses RecurrenceRule::setHonorRule()
     * @param string $frequency
     * @param int $count
     * @param string $until
     * @param int $interval
     * @param \StructType\DayOfYearWeekList $byDay
     * @param \StructType\DayOfMonthList $byMonthDay
     * @param \StructType\DayOfYearList $byYearDay
     * @param \StructType\MonthList $byMonth
     * @param \StructType\DayOfYearList $bySetPos
     * @param bool $honorRule
     */
    public function __construct($frequency = null, $count = null, $until = null, $interval = null, \StructType\DayOfYearWeekList $byDay = null, \StructType\DayOfMonthList $byMonthDay = null, \StructType\DayOfYearList $byYearDay = null, \StructType\MonthList $byMonth = null, \StructType\DayOfYearList $bySetPos = null, $honorRule = null)
    {
        $this
            ->setFrequency($frequency)
            ->setCount($count)
            ->setUntil($until)
            ->setInterval($interval)
            ->setByDay($byDay)
            ->setByMonthDay($byMonthDay)
            ->setByYearDay($byYearDay)
            ->setByMonth($byMonth)
            ->setBySetPos($bySetPos)
            ->setHonorRule($honorRule);
    }
    /**
     * Get frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->frequency;
    }
    /**
     * Set frequency value
     * @uses \EnumType\Frequency::valueIsValid()
     * @uses \EnumType\Frequency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $frequency
     * @return \StructType\RecurrenceRule
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Frequency::valueIsValid($frequency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $frequency, implode(', ', \EnumType\Frequency::getValidValues())), __LINE__);
        }
        $this->frequency = $frequency;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\RecurrenceRule
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get until value
     * @return string|null
     */
    public function getUntil()
    {
        return $this->until;
    }
    /**
     * Set until value
     * @param string $until
     * @return \StructType\RecurrenceRule
     */
    public function setUntil($until = null)
    {
        // validation for constraint: string
        if (!is_null($until) && !is_string($until)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($until)), __LINE__);
        }
        $this->until = $until;
        return $this;
    }
    /**
     * Get interval value
     * @return int|null
     */
    public function getInterval()
    {
        return $this->interval;
    }
    /**
     * Set interval value
     * @param int $interval
     * @return \StructType\RecurrenceRule
     */
    public function setInterval($interval = null)
    {
        // validation for constraint: int
        if (!is_null($interval) && !is_numeric($interval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interval)), __LINE__);
        }
        $this->interval = $interval;
        return $this;
    }
    /**
     * Get byDay value
     * @return \StructType\DayOfYearWeekList|null
     */
    public function getByDay()
    {
        return $this->byDay;
    }
    /**
     * Set byDay value
     * @param \StructType\DayOfYearWeekList $byDay
     * @return \StructType\RecurrenceRule
     */
    public function setByDay(\StructType\DayOfYearWeekList $byDay = null)
    {
        $this->byDay = $byDay;
        return $this;
    }
    /**
     * Get byMonthDay value
     * @return \StructType\DayOfMonthList|null
     */
    public function getByMonthDay()
    {
        return $this->byMonthDay;
    }
    /**
     * Set byMonthDay value
     * @param \StructType\DayOfMonthList $byMonthDay
     * @return \StructType\RecurrenceRule
     */
    public function setByMonthDay(\StructType\DayOfMonthList $byMonthDay = null)
    {
        $this->byMonthDay = $byMonthDay;
        return $this;
    }
    /**
     * Get byYearDay value
     * @return \StructType\DayOfYearList|null
     */
    public function getByYearDay()
    {
        return $this->byYearDay;
    }
    /**
     * Set byYearDay value
     * @param \StructType\DayOfYearList $byYearDay
     * @return \StructType\RecurrenceRule
     */
    public function setByYearDay(\StructType\DayOfYearList $byYearDay = null)
    {
        $this->byYearDay = $byYearDay;
        return $this;
    }
    /**
     * Get byMonth value
     * @return \StructType\MonthList|null
     */
    public function getByMonth()
    {
        return $this->byMonth;
    }
    /**
     * Set byMonth value
     * @param \StructType\MonthList $byMonth
     * @return \StructType\RecurrenceRule
     */
    public function setByMonth(\StructType\MonthList $byMonth = null)
    {
        $this->byMonth = $byMonth;
        return $this;
    }
    /**
     * Get bySetPos value
     * @return \StructType\DayOfYearList|null
     */
    public function getBySetPos()
    {
        return $this->bySetPos;
    }
    /**
     * Set bySetPos value
     * @param \StructType\DayOfYearList $bySetPos
     * @return \StructType\RecurrenceRule
     */
    public function setBySetPos(\StructType\DayOfYearList $bySetPos = null)
    {
        $this->bySetPos = $bySetPos;
        return $this;
    }
    /**
     * Get honorRule value
     * @return bool|null
     */
    public function getHonorRule()
    {
        return $this->honorRule;
    }
    /**
     * Set honorRule value
     * @param bool $honorRule
     * @return \StructType\RecurrenceRule
     */
    public function setHonorRule($honorRule = null)
    {
        // validation for constraint: boolean
        if (!is_null($honorRule) && !is_bool($honorRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($honorRule)), __LINE__);
        }
        $this->honorRule = $honorRule;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecurrenceRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
