<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recipient StructType
 * @subpackage Structs
 */
class Recipient extends NameAndEmail
{
    /**
     * The distType
     * Meta informations extracted from the WSDL
     * - default: TO
     * - minOccurs: 0
     * @var string
     */
    public $distType;
    /**
     * The recipType
     * Meta informations extracted from the WSDL
     * - default: User
     * - minOccurs: 0
     * @var string
     */
    public $recipType;
    /**
     * The recipientStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecipientStatus
     */
    public $recipientStatus;
    /**
     * The acceptLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:acceptLevel
     * @var string
     */
    public $acceptLevel;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The postOffice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postOffice;
    /**
     * The idomain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idomain;
    /**
     * Constructor method for Recipient
     * @uses Recipient::setDistType()
     * @uses Recipient::setRecipType()
     * @uses Recipient::setRecipientStatus()
     * @uses Recipient::setAcceptLevel()
     * @uses Recipient::setDomain()
     * @uses Recipient::setPostOffice()
     * @uses Recipient::setIdomain()
     * @param string $distType
     * @param string $recipType
     * @param \StructType\RecipientStatus $recipientStatus
     * @param string $acceptLevel
     * @param string $domain
     * @param string $postOffice
     * @param string $idomain
     */
    public function __construct($distType = 'TO', $recipType = 'User', \StructType\RecipientStatus $recipientStatus = null, $acceptLevel = null, $domain = null, $postOffice = null, $idomain = null)
    {
        $this
            ->setDistType($distType)
            ->setRecipType($recipType)
            ->setRecipientStatus($recipientStatus)
            ->setAcceptLevel($acceptLevel)
            ->setDomain($domain)
            ->setPostOffice($postOffice)
            ->setIdomain($idomain);
    }
    /**
     * Get distType value
     * @return string|null
     */
    public function getDistType()
    {
        return $this->distType;
    }
    /**
     * Set distType value
     * @uses \EnumType\DistributionType::valueIsValid()
     * @uses \EnumType\DistributionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distType
     * @return \StructType\Recipient
     */
    public function setDistType($distType = 'TO')
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistributionType::valueIsValid($distType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distType, implode(', ', \EnumType\DistributionType::getValidValues())), __LINE__);
        }
        $this->distType = $distType;
        return $this;
    }
    /**
     * Get recipType value
     * @return string|null
     */
    public function getRecipType()
    {
        return $this->recipType;
    }
    /**
     * Set recipType value
     * @uses \EnumType\RecipientType::valueIsValid()
     * @uses \EnumType\RecipientType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recipType
     * @return \StructType\Recipient
     */
    public function setRecipType($recipType = 'User')
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecipientType::valueIsValid($recipType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recipType, implode(', ', \EnumType\RecipientType::getValidValues())), __LINE__);
        }
        $this->recipType = $recipType;
        return $this;
    }
    /**
     * Get recipientStatus value
     * @return \StructType\RecipientStatus|null
     */
    public function getRecipientStatus()
    {
        return $this->recipientStatus;
    }
    /**
     * Set recipientStatus value
     * @param \StructType\RecipientStatus $recipientStatus
     * @return \StructType\Recipient
     */
    public function setRecipientStatus(\StructType\RecipientStatus $recipientStatus = null)
    {
        $this->recipientStatus = $recipientStatus;
        return $this;
    }
    /**
     * Get acceptLevel value
     * @return string|null
     */
    public function getAcceptLevel()
    {
        return $this->acceptLevel;
    }
    /**
     * Set acceptLevel value
     * @uses \EnumType\AcceptLevel::valueIsValid()
     * @uses \EnumType\AcceptLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptLevel
     * @return \StructType\Recipient
     */
    public function setAcceptLevel($acceptLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AcceptLevel::valueIsValid($acceptLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $acceptLevel, implode(', ', \EnumType\AcceptLevel::getValidValues())), __LINE__);
        }
        $this->acceptLevel = $acceptLevel;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\Recipient
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get postOffice value
     * @return string|null
     */
    public function getPostOffice()
    {
        return $this->postOffice;
    }
    /**
     * Set postOffice value
     * @param string $postOffice
     * @return \StructType\Recipient
     */
    public function setPostOffice($postOffice = null)
    {
        // validation for constraint: string
        if (!is_null($postOffice) && !is_string($postOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postOffice)), __LINE__);
        }
        $this->postOffice = $postOffice;
        return $this;
    }
    /**
     * Get idomain value
     * @return string|null
     */
    public function getIdomain()
    {
        return $this->idomain;
    }
    /**
     * Set idomain value
     * @param string $idomain
     * @return \StructType\Recipient
     */
    public function setIdomain($idomain = null)
    {
        // validation for constraint: string
        if (!is_null($idomain) && !is_string($idomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idomain)), __LINE__);
        }
        $this->idomain = $idomain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Recipient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
