<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RangeDays StructType
 * @subpackage Structs
 */
class RangeDays extends AbstractStructBase
{
    /**
     * The previous
     * @var int
     */
    public $previous;
    /**
     * The through
     * @var int
     */
    public $through;
    /**
     * Constructor method for RangeDays
     * @uses RangeDays::setPrevious()
     * @uses RangeDays::setThrough()
     * @param int $previous
     * @param int $through
     */
    public function __construct($previous = null, $through = null)
    {
        $this
            ->setPrevious($previous)
            ->setThrough($through);
    }
    /**
     * Get previous value
     * @return int|null
     */
    public function getPrevious()
    {
        return $this->previous;
    }
    /**
     * Set previous value
     * @param int $previous
     * @return \StructType\RangeDays
     */
    public function setPrevious($previous = null)
    {
        // validation for constraint: int
        if (!is_null($previous) && !is_numeric($previous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($previous)), __LINE__);
        }
        $this->previous = $previous;
        return $this;
    }
    /**
     * Get through value
     * @return int|null
     */
    public function getThrough()
    {
        return $this->through;
    }
    /**
     * Set through value
     * @param int $through
     * @return \StructType\RangeDays
     */
    public function setThrough($through = null)
    {
        // validation for constraint: int
        if (!is_null($through) && !is_numeric($through)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($through)), __LINE__);
        }
        $this->through = $through;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RangeDays
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
