<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryTargetList StructType
 * @subpackage Structs
 */
class QueryTargetList extends AbstractStructBase
{
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\QueryTarget[]
     */
    public $target;
    /**
     * Constructor method for QueryTargetList
     * @uses QueryTargetList::setTarget()
     * @param \StructType\QueryTarget[] $target
     */
    public function __construct(array $target = array())
    {
        $this
            ->setTarget($target);
    }
    /**
     * Get target value
     * @return \StructType\QueryTarget[]|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @throws \InvalidArgumentException
     * @param \StructType\QueryTarget[] $target
     * @return \StructType\QueryTargetList
     */
    public function setTarget(array $target = array())
    {
        foreach ($target as $queryTargetListTargetItem) {
            // validation for constraint: itemType
            if (!$queryTargetListTargetItem instanceof \StructType\QueryTarget) {
                throw new \InvalidArgumentException(sprintf('The target property can only contain items of \StructType\QueryTarget, "%s" given', is_object($queryTargetListTargetItem) ? get_class($queryTargetListTargetItem) : gettype($queryTargetListTargetItem)), __LINE__);
            }
        }
        $this->target = $target;
        return $this;
    }
    /**
     * Add item to target value
     * @throws \InvalidArgumentException
     * @param \StructType\QueryTarget $item
     * @return \StructType\QueryTargetList
     */
    public function addToTarget(\StructType\QueryTarget $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QueryTarget) {
            throw new \InvalidArgumentException(sprintf('The target property can only contain items of \StructType\QueryTarget, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->target[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QueryTargetList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
