<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for purgeRequest StructType
 * @subpackage Structs
 */
class PurgeRequest extends AbstractStructBase
{
    /**
     * The items
     * @var \StructType\ItemRefList
     */
    public $items;
    /**
     * The recurrenceAllInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recurrenceAllInstances;
    /**
     * The force
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var bool
     */
    public $force;
    /**
     * Constructor method for purgeRequest
     * @uses PurgeRequest::setItems()
     * @uses PurgeRequest::setRecurrenceAllInstances()
     * @uses PurgeRequest::setForce()
     * @param \StructType\ItemRefList $items
     * @param int $recurrenceAllInstances
     * @param bool $force
     */
    public function __construct(\StructType\ItemRefList $items = null, $recurrenceAllInstances = null, $force = false)
    {
        $this
            ->setItems($items)
            ->setRecurrenceAllInstances($recurrenceAllInstances)
            ->setForce($force);
    }
    /**
     * Get items value
     * @return \StructType\ItemRefList|null
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * Set items value
     * @param \StructType\ItemRefList $items
     * @return \StructType\PurgeRequest
     */
    public function setItems(\StructType\ItemRefList $items = null)
    {
        $this->items = $items;
        return $this;
    }
    /**
     * Get recurrenceAllInstances value
     * @return int|null
     */
    public function getRecurrenceAllInstances()
    {
        return $this->recurrenceAllInstances;
    }
    /**
     * Set recurrenceAllInstances value
     * @param int $recurrenceAllInstances
     * @return \StructType\PurgeRequest
     */
    public function setRecurrenceAllInstances($recurrenceAllInstances = null)
    {
        // validation for constraint: int
        if (!is_null($recurrenceAllInstances) && !is_numeric($recurrenceAllInstances)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recurrenceAllInstances)), __LINE__);
        }
        $this->recurrenceAllInstances = $recurrenceAllInstances;
        return $this;
    }
    /**
     * Get force value
     * @return bool|null
     */
    public function getForce()
    {
        return $this->force;
    }
    /**
     * Set force value
     * @param bool $force
     * @return \StructType\PurgeRequest
     */
    public function setForce($force = false)
    {
        // validation for constraint: boolean
        if (!is_null($force) && !is_bool($force)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($force)), __LINE__);
        }
        $this->force = $force;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurgeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
