<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProxyList StructType
 * @subpackage Structs
 */
class ProxyList extends AbstractStructBase
{
    /**
     * The proxy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProxyUser[]
     */
    public $proxy;
    /**
     * Constructor method for ProxyList
     * @uses ProxyList::setProxy()
     * @param \StructType\ProxyUser[] $proxy
     */
    public function __construct(array $proxy = array())
    {
        $this
            ->setProxy($proxy);
    }
    /**
     * Get proxy value
     * @return \StructType\ProxyUser[]|null
     */
    public function getProxy()
    {
        return $this->proxy;
    }
    /**
     * Set proxy value
     * @throws \InvalidArgumentException
     * @param \StructType\ProxyUser[] $proxy
     * @return \StructType\ProxyList
     */
    public function setProxy(array $proxy = array())
    {
        foreach ($proxy as $proxyListProxyItem) {
            // validation for constraint: itemType
            if (!$proxyListProxyItem instanceof \StructType\ProxyUser) {
                throw new \InvalidArgumentException(sprintf('The proxy property can only contain items of \StructType\ProxyUser, "%s" given', is_object($proxyListProxyItem) ? get_class($proxyListProxyItem) : gettype($proxyListProxyItem)), __LINE__);
            }
        }
        $this->proxy = $proxy;
        return $this;
    }
    /**
     * Add item to proxy value
     * @throws \InvalidArgumentException
     * @param \StructType\ProxyUser $item
     * @return \StructType\ProxyList
     */
    public function addToProxy(\StructType\ProxyUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProxyUser) {
            throw new \InvalidArgumentException(sprintf('The proxy property can only contain items of \StructType\ProxyUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->proxy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProxyList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
