<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProxyFolder StructType
 * @subpackage Structs
 */
class ProxyFolder extends Folder
{
    /**
     * The folderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $folderType;
    /**
     * The proxy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $proxy;
    /**
     * Constructor method for ProxyFolder
     * @uses ProxyFolder::setFolderType()
     * @uses ProxyFolder::setProxy()
     * @param string $folderType
     * @param \StructType\NameAndEmail $proxy
     */
    public function __construct($folderType = null, \StructType\NameAndEmail $proxy = null)
    {
        $this
            ->setFolderType($folderType)
            ->setProxy($proxy);
    }
    /**
     * Get folderType value
     * @return string|null
     */
    public function getFolderType()
    {
        return $this->folderType;
    }
    /**
     * Set folderType value
     * @uses \EnumType\FolderType::valueIsValid()
     * @uses \EnumType\FolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $folderType
     * @return \StructType\ProxyFolder
     */
    public function setFolderType($folderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FolderType::valueIsValid($folderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $folderType, implode(', ', \EnumType\FolderType::getValidValues())), __LINE__);
        }
        $this->folderType = $folderType;
        return $this;
    }
    /**
     * Get proxy value
     * @return \StructType\NameAndEmail|null
     */
    public function getProxy()
    {
        return $this->proxy;
    }
    /**
     * Set proxy value
     * @param \StructType\NameAndEmail $proxy
     * @return \StructType\ProxyFolder
     */
    public function setProxy(\StructType\NameAndEmail $proxy = null)
    {
        $this->proxy = $proxy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProxyFolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
