<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proxy StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: xs:int
 * @subpackage Structs
 */
class Proxy extends Authentication
{
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The proxy
     * @var string
     */
    public $proxy;
    /**
     * Constructor method for Proxy
     * @uses Proxy::setPassword()
     * @uses Proxy::setProxy()
     * @param string $password
     * @param string $proxy
     */
    public function __construct($password = null, $proxy = null)
    {
        $this
            ->setPassword($password)
            ->setProxy($proxy);
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Proxy
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get proxy value
     * @return string|null
     */
    public function getProxy()
    {
        return $this->proxy;
    }
    /**
     * Set proxy value
     * @param string $proxy
     * @return \StructType\Proxy
     */
    public function setProxy($proxy = null)
    {
        // validation for constraint: string
        if (!is_null($proxy) && !is_string($proxy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxy)), __LINE__);
        }
        $this->proxy = $proxy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Proxy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
