<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for positionCursorRequest StructType
 * @subpackage Structs
 */
class PositionCursorRequest extends AbstractStructBase
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - minOccurs: 0
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The cursor
     * @var int
     */
    public $cursor;
    /**
     * The seek
     * @var string
     */
    public $seek;
    /**
     * The offset
     * @var int
     */
    public $offset;
    /**
     * Constructor method for positionCursorRequest
     * @uses PositionCursorRequest::setContainer()
     * @uses PositionCursorRequest::setCursor()
     * @uses PositionCursorRequest::setSeek()
     * @uses PositionCursorRequest::setOffset()
     * @param string $container
     * @param int $cursor
     * @param string $seek
     * @param int $offset
     */
    public function __construct($container = null, $cursor = null, $seek = null, $offset = null)
    {
        $this
            ->setContainer($container)
            ->setCursor($cursor)
            ->setSeek($seek)
            ->setOffset($offset);
    }
    /**
     * Get container value
     * @return string|null
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\PositionCursorRequest
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get cursor value
     * @return int|null
     */
    public function getCursor()
    {
        return $this->cursor;
    }
    /**
     * Set cursor value
     * @param int $cursor
     * @return \StructType\PositionCursorRequest
     */
    public function setCursor($cursor = null)
    {
        // validation for constraint: int
        if (!is_null($cursor) && !is_numeric($cursor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cursor)), __LINE__);
        }
        $this->cursor = $cursor;
        return $this;
    }
    /**
     * Get seek value
     * @return string|null
     */
    public function getSeek()
    {
        return $this->seek;
    }
    /**
     * Set seek value
     * @uses \EnumType\CursorSeek::valueIsValid()
     * @uses \EnumType\CursorSeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seek
     * @return \StructType\PositionCursorRequest
     */
    public function setSeek($seek = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CursorSeek::valueIsValid($seek)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $seek, implode(', ', \EnumType\CursorSeek::getValidValues())), __LINE__);
        }
        $this->seek = $seek;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\PositionCursorRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionCursorRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
