<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PollSettings StructType
 * @subpackage Structs
 */
class PollSettings extends AbstractStructBase
{
    /**
     * The pollAtStartup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pollAtStartup;
    /**
     * The pollMarkedAccounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pollMarkedAccounts;
    /**
     * The pollInterval
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pollInterval;
    /**
     * Constructor method for PollSettings
     * @uses PollSettings::setPollAtStartup()
     * @uses PollSettings::setPollMarkedAccounts()
     * @uses PollSettings::setPollInterval()
     * @param bool $pollAtStartup
     * @param bool $pollMarkedAccounts
     * @param int $pollInterval
     */
    public function __construct($pollAtStartup = null, $pollMarkedAccounts = null, $pollInterval = null)
    {
        $this
            ->setPollAtStartup($pollAtStartup)
            ->setPollMarkedAccounts($pollMarkedAccounts)
            ->setPollInterval($pollInterval);
    }
    /**
     * Get pollAtStartup value
     * @return bool|null
     */
    public function getPollAtStartup()
    {
        return $this->pollAtStartup;
    }
    /**
     * Set pollAtStartup value
     * @param bool $pollAtStartup
     * @return \StructType\PollSettings
     */
    public function setPollAtStartup($pollAtStartup = null)
    {
        // validation for constraint: boolean
        if (!is_null($pollAtStartup) && !is_bool($pollAtStartup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pollAtStartup)), __LINE__);
        }
        $this->pollAtStartup = $pollAtStartup;
        return $this;
    }
    /**
     * Get pollMarkedAccounts value
     * @return bool|null
     */
    public function getPollMarkedAccounts()
    {
        return $this->pollMarkedAccounts;
    }
    /**
     * Set pollMarkedAccounts value
     * @param bool $pollMarkedAccounts
     * @return \StructType\PollSettings
     */
    public function setPollMarkedAccounts($pollMarkedAccounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($pollMarkedAccounts) && !is_bool($pollMarkedAccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pollMarkedAccounts)), __LINE__);
        }
        $this->pollMarkedAccounts = $pollMarkedAccounts;
        return $this;
    }
    /**
     * Get pollInterval value
     * @return int|null
     */
    public function getPollInterval()
    {
        return $this->pollInterval;
    }
    /**
     * Set pollInterval value
     * @param int $pollInterval
     * @return \StructType\PollSettings
     */
    public function setPollInterval($pollInterval = null)
    {
        // validation for constraint: int
        if (!is_null($pollInterval) && !is_numeric($pollInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pollInterval)), __LINE__);
        }
        $this->pollInterval = $pollInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PollSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
