<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pollResponse StructType
 * @subpackage Structs
 */
class PollResponse extends AbstractStructBase
{
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sequence;
    /**
     * The list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PollInfoList
     */
    public $list;
    /**
     * The status
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for pollResponse
     * @uses PollResponse::setSequence()
     * @uses PollResponse::setList()
     * @uses PollResponse::setStatus()
     * @param int $sequence
     * @param \StructType\PollInfoList $list
     * @param \StructType\Status $status
     */
    public function __construct($sequence = null, \StructType\PollInfoList $list = null, \StructType\Status $status = null)
    {
        $this
            ->setSequence($sequence)
            ->setList($list)
            ->setStatus($status);
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\PollResponse
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get list value
     * @return \StructType\PollInfoList|null
     */
    public function getList()
    {
        return $this->list;
    }
    /**
     * Set list value
     * @param \StructType\PollInfoList $list
     * @return \StructType\PollResponse
     */
    public function setList(\StructType\PollInfoList $list = null)
    {
        $this->list = $list;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\PollResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PollResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
