<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PollInfoList StructType
 * @subpackage Structs
 */
class PollInfoList extends AbstractStructBase
{
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PollInfo[]
     */
    public $info;
    /**
     * Constructor method for PollInfoList
     * @uses PollInfoList::setInfo()
     * @param \StructType\PollInfo[] $info
     */
    public function __construct(array $info = array())
    {
        $this
            ->setInfo($info);
    }
    /**
     * Get info value
     * @return \StructType\PollInfo[]|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @throws \InvalidArgumentException
     * @param \StructType\PollInfo[] $info
     * @return \StructType\PollInfoList
     */
    public function setInfo(array $info = array())
    {
        foreach ($info as $pollInfoListInfoItem) {
            // validation for constraint: itemType
            if (!$pollInfoListInfoItem instanceof \StructType\PollInfo) {
                throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\PollInfo, "%s" given', is_object($pollInfoListInfoItem) ? get_class($pollInfoListInfoItem) : gettype($pollInfoListInfoItem)), __LINE__);
            }
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Add item to info value
     * @throws \InvalidArgumentException
     * @param \StructType\PollInfo $item
     * @return \StructType\PollInfoList
     */
    public function addToInfo(\StructType\PollInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PollInfo) {
            throw new \InvalidArgumentException(sprintf('The info property can only contain items of \StructType\PollInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PollInfoList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
