<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PollInfo StructType
 * @subpackage Structs
 */
class PollInfo extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - ref: tns:id
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $id;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The sid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:sid
     * @var int
     */
    public $sid;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:sequence
     * @var int
     */
    public $sequence;
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $item;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:startDate
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:endDate
     * @var string
     */
    public $endDate;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemStatus
     */
    public $status;
    /**
     * The referenceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $referenceCount;
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContainerRef[]
     */
    public $container;
    /**
     * The delta
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PollField[]
     */
    public $delta;
    /**
     * Constructor method for PollInfo
     * @uses PollInfo::setId()
     * @uses PollInfo::setType()
     * @uses PollInfo::setSid()
     * @uses PollInfo::setSequence()
     * @uses PollInfo::setItem()
     * @uses PollInfo::setStartDate()
     * @uses PollInfo::setEndDate()
     * @uses PollInfo::setSource()
     * @uses PollInfo::setMessage()
     * @uses PollInfo::setStatus()
     * @uses PollInfo::setReferenceCount()
     * @uses PollInfo::setContainer()
     * @uses PollInfo::setDelta()
     * @param string $id
     * @param string $type
     * @param int $sid
     * @param int $sequence
     * @param string $item
     * @param string $startDate
     * @param string $endDate
     * @param string $source
     * @param string $message
     * @param \StructType\ItemStatus $status
     * @param int $referenceCount
     * @param \StructType\ContainerRef[] $container
     * @param \StructType\PollField[] $delta
     */
    public function __construct($id = null, $type = null, $sid = null, $sequence = null, $item = null, $startDate = null, $endDate = null, $source = null, $message = null, \StructType\ItemStatus $status = null, $referenceCount = null, array $container = array(), array $delta = array())
    {
        $this
            ->setId($id)
            ->setType($type)
            ->setSid($sid)
            ->setSequence($sequence)
            ->setItem($item)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setSource($source)
            ->setMessage($message)
            ->setStatus($status)
            ->setReferenceCount($referenceCount)
            ->setContainer($container)
            ->setDelta($delta);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\PollInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[^@]+(@*)?/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\PollInfoType::valueIsValid()
     * @uses \EnumType\PollInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\PollInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PollInfoType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\PollInfoType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get sid value
     * @return int|null
     */
    public function getSid()
    {
        return $this->sid;
    }
    /**
     * Set sid value
     * @param int $sid
     * @return \StructType\PollInfo
     */
    public function setSid($sid = null)
    {
        // validation for constraint: int
        if (!is_null($sid) && !is_numeric($sid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sid)), __LINE__);
        }
        $this->sid = $sid;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\PollInfo
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get item value
     * @return string|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @uses \EnumType\PollItemType::valueIsValid()
     * @uses \EnumType\PollItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PollInfo
     */
    public function setItem($item = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PollItemType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\PollItemType::getValidValues())), __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\PollInfo
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\PollInfo
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @uses \EnumType\ItemSource::valueIsValid()
     * @uses \EnumType\ItemSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\PollInfo
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemSource::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $source, implode(', ', \EnumType\ItemSource::getValidValues())), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @uses \EnumType\MessageType::valueIsValid()
     * @uses \EnumType\MessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $message
     * @return \StructType\PollInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageType::valueIsValid($message)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $message, implode(', ', \EnumType\MessageType::getValidValues())), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\ItemStatus|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\ItemStatus $status
     * @return \StructType\PollInfo
     */
    public function setStatus(\StructType\ItemStatus $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get referenceCount value
     * @return int|null
     */
    public function getReferenceCount()
    {
        return $this->referenceCount;
    }
    /**
     * Set referenceCount value
     * @param int $referenceCount
     * @return \StructType\PollInfo
     */
    public function setReferenceCount($referenceCount = null)
    {
        // validation for constraint: int
        if (!is_null($referenceCount) && !is_numeric($referenceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($referenceCount)), __LINE__);
        }
        $this->referenceCount = $referenceCount;
        return $this;
    }
    /**
     * Get container value
     * @return \StructType\ContainerRef[]|null
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @throws \InvalidArgumentException
     * @param \StructType\ContainerRef[] $container
     * @return \StructType\PollInfo
     */
    public function setContainer(array $container = array())
    {
        foreach ($container as $pollInfoContainerItem) {
            // validation for constraint: itemType
            if (!$pollInfoContainerItem instanceof \StructType\ContainerRef) {
                throw new \InvalidArgumentException(sprintf('The container property can only contain items of \StructType\ContainerRef, "%s" given', is_object($pollInfoContainerItem) ? get_class($pollInfoContainerItem) : gettype($pollInfoContainerItem)), __LINE__);
            }
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Add item to container value
     * @throws \InvalidArgumentException
     * @param \StructType\ContainerRef $item
     * @return \StructType\PollInfo
     */
    public function addToContainer(\StructType\ContainerRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContainerRef) {
            throw new \InvalidArgumentException(sprintf('The container property can only contain items of \StructType\ContainerRef, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->container[] = $item;
        return $this;
    }
    /**
     * Get delta value
     * @return \StructType\PollField[]|null
     */
    public function getDelta()
    {
        return $this->delta;
    }
    /**
     * Set delta value
     * @throws \InvalidArgumentException
     * @param \StructType\PollField[] $delta
     * @return \StructType\PollInfo
     */
    public function setDelta(array $delta = array())
    {
        foreach ($delta as $pollInfoDeltaItem) {
            // validation for constraint: itemType
            if (!$pollInfoDeltaItem instanceof \StructType\PollField) {
                throw new \InvalidArgumentException(sprintf('The delta property can only contain items of \StructType\PollField, "%s" given', is_object($pollInfoDeltaItem) ? get_class($pollInfoDeltaItem) : gettype($pollInfoDeltaItem)), __LINE__);
            }
        }
        $this->delta = $delta;
        return $this;
    }
    /**
     * Add item to delta value
     * @throws \InvalidArgumentException
     * @param \StructType\PollField $item
     * @return \StructType\PollInfo
     */
    public function addToDelta(\StructType\PollField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PollField) {
            throw new \InvalidArgumentException(sprintf('The delta property can only contain items of \StructType\PollField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->delta[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PollInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
