<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PollField StructType
 * @subpackage Structs
 */
class PollField extends AbstractStructBase
{
    /**
     * The field
     * @var string
     */
    public $field;
    /**
     * The method
     * @var string
     */
    public $method;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContainerRef
     */
    public $container;
    /**
     * The timezone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Timezone
     */
    public $timezone;
    /**
     * Constructor method for PollField
     * @uses PollField::setField()
     * @uses PollField::setMethod()
     * @uses PollField::setValue()
     * @uses PollField::setContainer()
     * @uses PollField::setTimezone()
     * @param string $field
     * @param string $method
     * @param string $value
     * @param \StructType\ContainerRef $container
     * @param \StructType\Timezone $timezone
     */
    public function __construct($field = null, $method = null, $value = null, \StructType\ContainerRef $container = null, \StructType\Timezone $timezone = null)
    {
        $this
            ->setField($field)
            ->setMethod($method)
            ->setValue($value)
            ->setContainer($container)
            ->setTimezone($timezone);
    }
    /**
     * Get field value
     * @return string|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\PollField
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Get method value
     * @return string|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @uses \EnumType\Method::valueIsValid()
     * @uses \EnumType\Method::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $method
     * @return \StructType\PollField
     */
    public function setMethod($method = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Method::valueIsValid($method)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $method, implode(', ', \EnumType\Method::getValidValues())), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\PollField
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get container value
     * @return \StructType\ContainerRef|null
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param \StructType\ContainerRef $container
     * @return \StructType\PollField
     */
    public function setContainer(\StructType\ContainerRef $container = null)
    {
        $this->container = $container;
        return $this;
    }
    /**
     * Get timezone value
     * @return \StructType\Timezone|null
     */
    public function getTimezone()
    {
        return $this->timezone;
    }
    /**
     * Set timezone value
     * @param \StructType\Timezone $timezone
     * @return \StructType\PollField
     */
    public function setTimezone(\StructType\Timezone $timezone = null)
    {
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PollField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
