<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PictureData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contacts now support a picture. The picture has the following restrictions: 1. The file format is jpeg. The contentType below specifies the mime contentType of "image/jpeg". 2. The size of the file must be less than 2K. 3. The
 * maximum dimensions of the image is 64 X 64 pixels. Developers should ensure that any images meet the above criteria.
 * - minOccurs: 0
 * - type: xs:string
 * @subpackage Structs
 */
class PictureData extends AbstractStructBase
{
    /**
     * The contentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contentType;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $size;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $data;
    /**
     * Constructor method for PictureData
     * @uses PictureData::setContentType()
     * @uses PictureData::setSize()
     * @uses PictureData::setData()
     * @param string $contentType
     * @param int $size
     * @param string $data
     */
    public function __construct($contentType = null, $size = null, $data = null)
    {
        $this
            ->setContentType($contentType)
            ->setSize($size)
            ->setData($data);
    }
    /**
     * Get contentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @param string $contentType
     * @return \StructType\PictureData
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentType)), __LINE__);
        }
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\PictureData
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !is_numeric($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\PictureData
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PictureData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
