<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneMessage StructType
 * @subpackage Structs
 */
class PhoneMessage extends Mail
{
    /**
     * The caller
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $caller;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $company;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PhoneFlags
     */
    public $flags;
    /**
     * Constructor method for PhoneMessage
     * @uses PhoneMessage::setCaller()
     * @uses PhoneMessage::setCompany()
     * @uses PhoneMessage::setPhone()
     * @uses PhoneMessage::setFlags()
     * @param string $caller
     * @param string $company
     * @param string $phone
     * @param \StructType\PhoneFlags $flags
     */
    public function __construct($caller = null, $company = null, $phone = null, \StructType\PhoneFlags $flags = null)
    {
        $this
            ->setCaller($caller)
            ->setCompany($company)
            ->setPhone($phone)
            ->setFlags($flags);
    }
    /**
     * Get caller value
     * @return string|null
     */
    public function getCaller()
    {
        return $this->caller;
    }
    /**
     * Set caller value
     * @param string $caller
     * @return \StructType\PhoneMessage
     */
    public function setCaller($caller = null)
    {
        // validation for constraint: string
        if (!is_null($caller) && !is_string($caller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($caller)), __LINE__);
        }
        $this->caller = $caller;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \StructType\PhoneMessage
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\PhoneMessage
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get flags value
     * @return \StructType\PhoneFlags|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param \StructType\PhoneFlags $flags
     * @return \StructType\PhoneMessage
     */
    public function setFlags(\StructType\PhoneFlags $flags = null)
    {
        $this->flags = $flags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhoneMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
