<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneList StructType
 * @subpackage Structs
 */
class PhoneList extends AbstractStructBase
{
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PhoneNumber[]
     */
    public $phone;
    /**
     * The default
     * @var string
     */
    public $default;
    /**
     * Constructor method for PhoneList
     * @uses PhoneList::setPhone()
     * @uses PhoneList::setDefault()
     * @param \StructType\PhoneNumber[] $phone
     * @param string $default
     */
    public function __construct(array $phone = array(), $default = null)
    {
        $this
            ->setPhone($phone)
            ->setDefault($default);
    }
    /**
     * Get phone value
     * @return \StructType\PhoneNumber[]|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneNumber[] $phone
     * @return \StructType\PhoneList
     */
    public function setPhone(array $phone = array())
    {
        foreach ($phone as $phoneListPhoneItem) {
            // validation for constraint: itemType
            if (!$phoneListPhoneItem instanceof \StructType\PhoneNumber) {
                throw new \InvalidArgumentException(sprintf('The phone property can only contain items of \StructType\PhoneNumber, "%s" given', is_object($phoneListPhoneItem) ? get_class($phoneListPhoneItem) : gettype($phoneListPhoneItem)), __LINE__);
            }
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Add item to phone value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneNumber $item
     * @return \StructType\PhoneList
     */
    public function addToPhone(\StructType\PhoneNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhoneNumber) {
            throw new \InvalidArgumentException(sprintf('The phone property can only contain items of \StructType\PhoneNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->phone[] = $item;
        return $this;
    }
    /**
     * Get default value
     * @return string|null
     */
    public function getDefault()
    {
        return $this->default;
    }
    /**
     * Set default value
     * @param string $default
     * @return \StructType\PhoneList
     */
    public function setDefault($default = null)
    {
        // validation for constraint: string
        if (!is_null($default) && !is_string($default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default)), __LINE__);
        }
        $this->default = $default;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhoneList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
