<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonalInfo StructType
 * Meta informations extracted from the WSDL
 * - minOccurs: 0
 * - type: tns:PictureData
 * @subpackage Structs
 */
class PersonalInfo extends AbstractStructBase
{
    /**
     * The birthday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $birthday;
    /**
     * The website
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $website;
    /**
     * The spouse
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $spouse;
    /**
     * The children
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $children;
    /**
     * The hobbies
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hobbies;
    /**
     * The nickName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nickName;
    /**
     * The picture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PictureData
     */
    public $picture;
    /**
     * The weddingAnniversary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $weddingAnniversary;
    /**
     * The displayBirthdayYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $displayBirthdayYear;
    /**
     * The displayAnniversaryYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $displayAnniversaryYear;
    /**
     * The timezone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Timezone
     */
    public $timezone;
    /**
     * Constructor method for PersonalInfo
     * @uses PersonalInfo::setBirthday()
     * @uses PersonalInfo::setWebsite()
     * @uses PersonalInfo::setSpouse()
     * @uses PersonalInfo::setChildren()
     * @uses PersonalInfo::setHobbies()
     * @uses PersonalInfo::setNickName()
     * @uses PersonalInfo::setPicture()
     * @uses PersonalInfo::setWeddingAnniversary()
     * @uses PersonalInfo::setDisplayBirthdayYear()
     * @uses PersonalInfo::setDisplayAnniversaryYear()
     * @uses PersonalInfo::setTimezone()
     * @param string $birthday
     * @param string $website
     * @param string $spouse
     * @param string $children
     * @param string $hobbies
     * @param string $nickName
     * @param \StructType\PictureData $picture
     * @param string $weddingAnniversary
     * @param bool $displayBirthdayYear
     * @param bool $displayAnniversaryYear
     * @param \StructType\Timezone $timezone
     */
    public function __construct($birthday = null, $website = null, $spouse = null, $children = null, $hobbies = null, $nickName = null, \StructType\PictureData $picture = null, $weddingAnniversary = null, $displayBirthdayYear = null, $displayAnniversaryYear = null, \StructType\Timezone $timezone = null)
    {
        $this
            ->setBirthday($birthday)
            ->setWebsite($website)
            ->setSpouse($spouse)
            ->setChildren($children)
            ->setHobbies($hobbies)
            ->setNickName($nickName)
            ->setPicture($picture)
            ->setWeddingAnniversary($weddingAnniversary)
            ->setDisplayBirthdayYear($displayBirthdayYear)
            ->setDisplayAnniversaryYear($displayAnniversaryYear)
            ->setTimezone($timezone);
    }
    /**
     * Get birthday value
     * @return string|null
     */
    public function getBirthday()
    {
        return $this->birthday;
    }
    /**
     * Set birthday value
     * @param string $birthday
     * @return \StructType\PersonalInfo
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthday)), __LINE__);
        }
        $this->birthday = $birthday;
        return $this;
    }
    /**
     * Get website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->website;
    }
    /**
     * Set website value
     * @param string $website
     * @return \StructType\PersonalInfo
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($website)), __LINE__);
        }
        $this->website = $website;
        return $this;
    }
    /**
     * Get spouse value
     * @return string|null
     */
    public function getSpouse()
    {
        return $this->spouse;
    }
    /**
     * Set spouse value
     * @param string $spouse
     * @return \StructType\PersonalInfo
     */
    public function setSpouse($spouse = null)
    {
        // validation for constraint: string
        if (!is_null($spouse) && !is_string($spouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spouse)), __LINE__);
        }
        $this->spouse = $spouse;
        return $this;
    }
    /**
     * Get children value
     * @return string|null
     */
    public function getChildren()
    {
        return $this->children;
    }
    /**
     * Set children value
     * @param string $children
     * @return \StructType\PersonalInfo
     */
    public function setChildren($children = null)
    {
        // validation for constraint: string
        if (!is_null($children) && !is_string($children)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($children)), __LINE__);
        }
        $this->children = $children;
        return $this;
    }
    /**
     * Get hobbies value
     * @return string|null
     */
    public function getHobbies()
    {
        return $this->hobbies;
    }
    /**
     * Set hobbies value
     * @param string $hobbies
     * @return \StructType\PersonalInfo
     */
    public function setHobbies($hobbies = null)
    {
        // validation for constraint: string
        if (!is_null($hobbies) && !is_string($hobbies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hobbies)), __LINE__);
        }
        $this->hobbies = $hobbies;
        return $this;
    }
    /**
     * Get nickName value
     * @return string|null
     */
    public function getNickName()
    {
        return $this->nickName;
    }
    /**
     * Set nickName value
     * @param string $nickName
     * @return \StructType\PersonalInfo
     */
    public function setNickName($nickName = null)
    {
        // validation for constraint: string
        if (!is_null($nickName) && !is_string($nickName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nickName)), __LINE__);
        }
        $this->nickName = $nickName;
        return $this;
    }
    /**
     * Get picture value
     * @return \StructType\PictureData|null
     */
    public function getPicture()
    {
        return $this->picture;
    }
    /**
     * Set picture value
     * @param \StructType\PictureData $picture
     * @return \StructType\PersonalInfo
     */
    public function setPicture(\StructType\PictureData $picture = null)
    {
        $this->picture = $picture;
        return $this;
    }
    /**
     * Get weddingAnniversary value
     * @return string|null
     */
    public function getWeddingAnniversary()
    {
        return $this->weddingAnniversary;
    }
    /**
     * Set weddingAnniversary value
     * @param string $weddingAnniversary
     * @return \StructType\PersonalInfo
     */
    public function setWeddingAnniversary($weddingAnniversary = null)
    {
        // validation for constraint: string
        if (!is_null($weddingAnniversary) && !is_string($weddingAnniversary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weddingAnniversary)), __LINE__);
        }
        $this->weddingAnniversary = $weddingAnniversary;
        return $this;
    }
    /**
     * Get displayBirthdayYear value
     * @return bool|null
     */
    public function getDisplayBirthdayYear()
    {
        return $this->displayBirthdayYear;
    }
    /**
     * Set displayBirthdayYear value
     * @param bool $displayBirthdayYear
     * @return \StructType\PersonalInfo
     */
    public function setDisplayBirthdayYear($displayBirthdayYear = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayBirthdayYear) && !is_bool($displayBirthdayYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($displayBirthdayYear)), __LINE__);
        }
        $this->displayBirthdayYear = $displayBirthdayYear;
        return $this;
    }
    /**
     * Get displayAnniversaryYear value
     * @return bool|null
     */
    public function getDisplayAnniversaryYear()
    {
        return $this->displayAnniversaryYear;
    }
    /**
     * Set displayAnniversaryYear value
     * @param bool $displayAnniversaryYear
     * @return \StructType\PersonalInfo
     */
    public function setDisplayAnniversaryYear($displayAnniversaryYear = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayAnniversaryYear) && !is_bool($displayAnniversaryYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($displayAnniversaryYear)), __LINE__);
        }
        $this->displayAnniversaryYear = $displayAnniversaryYear;
        return $this;
    }
    /**
     * Get timezone value
     * @return \StructType\Timezone|null
     */
    public function getTimezone()
    {
        return $this->timezone;
    }
    /**
     * Set timezone value
     * @param \StructType\Timezone $timezone
     * @return \StructType\PersonalInfo
     */
    public function setTimezone(\StructType\Timezone $timezone = null)
    {
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonalInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
