<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelList StructType
 * @subpackage Structs
 */
class PanelList extends AbstractStructBase
{
    /**
     * The panel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PanelDisplaySettings[]
     */
    public $panel;
    /**
     * Constructor method for PanelList
     * @uses PanelList::setPanel()
     * @param \StructType\PanelDisplaySettings[] $panel
     */
    public function __construct(array $panel = array())
    {
        $this
            ->setPanel($panel);
    }
    /**
     * Get panel value
     * @return \StructType\PanelDisplaySettings[]|null
     */
    public function getPanel()
    {
        return $this->panel;
    }
    /**
     * Set panel value
     * @throws \InvalidArgumentException
     * @param \StructType\PanelDisplaySettings[] $panel
     * @return \StructType\PanelList
     */
    public function setPanel(array $panel = array())
    {
        foreach ($panel as $panelListPanelItem) {
            // validation for constraint: itemType
            if (!$panelListPanelItem instanceof \StructType\PanelDisplaySettings) {
                throw new \InvalidArgumentException(sprintf('The panel property can only contain items of \StructType\PanelDisplaySettings, "%s" given', is_object($panelListPanelItem) ? get_class($panelListPanelItem) : gettype($panelListPanelItem)), __LINE__);
            }
        }
        $this->panel = $panel;
        return $this;
    }
    /**
     * Add item to panel value
     * @throws \InvalidArgumentException
     * @param \StructType\PanelDisplaySettings $item
     * @return \StructType\PanelList
     */
    public function addToPanel(\StructType\PanelDisplaySettings $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PanelDisplaySettings) {
            throw new \InvalidArgumentException(sprintf('The panel property can only contain items of \StructType\PanelDisplaySettings, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->panel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PanelList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
