<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelDisplaySettings StructType
 * @subpackage Structs
 */
class PanelDisplaySettings extends DisplaySettings
{
    /**
     * The container
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $container;
    /**
     * The parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0 | 0
     * - documentation: The unique identifier is a application defined string to uniquely identify an item. The string can optionally consist of two parts. The first part identifies a unique existence of an item. The second part of the string optionally
     * specifies instance information. The first and second part of the ID are separated by an '@'. For this reason neither the first nor second part can contain an '@' symbol. To determine whether or not two items are the same item, the consumer of this
     * API should compare the first part of the ids of the two items (i.e. all of the id up to the @ symbol).
     * - pattern: [^@]+(@*)?
     * - type: xs:string
     * @var string
     */
    public $parent;
    /**
     * The panelName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $panelName;
    /**
     * The column
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $column;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $index;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Filter
     */
    public $filter;
    /**
     * The splitBar
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $splitBar;
    /**
     * The width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $width;
    /**
     * The height
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $height;
    /**
     * The originalHeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $originalHeight;
    /**
     * The weekViewColumns
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $weekViewColumns;
    /**
     * The calendarView
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $calendarView;
    /**
     * The website
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $website;
    /**
     * The interval
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $interval;
    /**
     * The hScrollPosition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $hScrollPosition;
    /**
     * The vScrollPosition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vScrollPosition;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * Constructor method for PanelDisplaySettings
     * @uses PanelDisplaySettings::setContainer()
     * @uses PanelDisplaySettings::setParent()
     * @uses PanelDisplaySettings::setPanelName()
     * @uses PanelDisplaySettings::setColumn()
     * @uses PanelDisplaySettings::setIndex()
     * @uses PanelDisplaySettings::setFilter()
     * @uses PanelDisplaySettings::setSplitBar()
     * @uses PanelDisplaySettings::setWidth()
     * @uses PanelDisplaySettings::setHeight()
     * @uses PanelDisplaySettings::setOriginalHeight()
     * @uses PanelDisplaySettings::setWeekViewColumns()
     * @uses PanelDisplaySettings::setCalendarView()
     * @uses PanelDisplaySettings::setWebsite()
     * @uses PanelDisplaySettings::setInterval()
     * @uses PanelDisplaySettings::setHScrollPosition()
     * @uses PanelDisplaySettings::setVScrollPosition()
     * @uses PanelDisplaySettings::setDescription()
     * @param string $container
     * @param string $parent
     * @param string $panelName
     * @param int $column
     * @param int $index
     * @param \StructType\Filter $filter
     * @param string $splitBar
     * @param int $width
     * @param int $height
     * @param int $originalHeight
     * @param int $weekViewColumns
     * @param string $calendarView
     * @param string $website
     * @param int $interval
     * @param int $hScrollPosition
     * @param int $vScrollPosition
     * @param string $description
     */
    public function __construct($container = null, $parent = null, $panelName = null, $column = null, $index = null, \StructType\Filter $filter = null, $splitBar = null, $width = null, $height = null, $originalHeight = null, $weekViewColumns = null, $calendarView = null, $website = null, $interval = null, $hScrollPosition = null, $vScrollPosition = null, $description = null)
    {
        $this
            ->setContainer($container)
            ->setParent($parent)
            ->setPanelName($panelName)
            ->setColumn($column)
            ->setIndex($index)
            ->setFilter($filter)
            ->setSplitBar($splitBar)
            ->setWidth($width)
            ->setHeight($height)
            ->setOriginalHeight($originalHeight)
            ->setWeekViewColumns($weekViewColumns)
            ->setCalendarView($calendarView)
            ->setWebsite($website)
            ->setInterval($interval)
            ->setHScrollPosition($hScrollPosition)
            ->setVScrollPosition($vScrollPosition)
            ->setDescription($description);
    }
    /**
     * Get container value
     * @return string
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param string $container
     * @return \StructType\PanelDisplaySettings
     */
    public function setContainer($container = null)
    {
        // validation for constraint: pattern
        if (is_scalar($container) && !preg_match('/[^@]+(@*)?/', $container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($container, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($container) && !is_string($container)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($container)), __LINE__);
        }
        $this->container = $container;
        return $this;
    }
    /**
     * Get parent value
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param string $parent
     * @return \StructType\PanelDisplaySettings
     */
    public function setParent($parent = null)
    {
        // validation for constraint: pattern
        if (is_scalar($parent) && !preg_match('/[^@]+(@*)?/', $parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[^@]+(@*)?", "%s" given', var_export($parent, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parent) && !is_string($parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parent)), __LINE__);
        }
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get panelName value
     * @return string|null
     */
    public function getPanelName()
    {
        return $this->panelName;
    }
    /**
     * Set panelName value
     * @param string $panelName
     * @return \StructType\PanelDisplaySettings
     */
    public function setPanelName($panelName = null)
    {
        // validation for constraint: string
        if (!is_null($panelName) && !is_string($panelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($panelName)), __LINE__);
        }
        $this->panelName = $panelName;
        return $this;
    }
    /**
     * Get column value
     * @return int|null
     */
    public function getColumn()
    {
        return $this->column;
    }
    /**
     * Set column value
     * @param int $column
     * @return \StructType\PanelDisplaySettings
     */
    public function setColumn($column = null)
    {
        // validation for constraint: int
        if (!is_null($column) && !is_numeric($column)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($column)), __LINE__);
        }
        $this->column = $column;
        return $this;
    }
    /**
     * Get index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \StructType\PanelDisplaySettings
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !is_numeric($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get filter value
     * @return \StructType\Filter|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param \StructType\Filter $filter
     * @return \StructType\PanelDisplaySettings
     */
    public function setFilter(\StructType\Filter $filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get splitBar value
     * @return string|null
     */
    public function getSplitBar()
    {
        return $this->splitBar;
    }
    /**
     * Set splitBar value
     * @param string $splitBar
     * @return \StructType\PanelDisplaySettings
     */
    public function setSplitBar($splitBar = null)
    {
        // validation for constraint: string
        if (!is_null($splitBar) && !is_string($splitBar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($splitBar)), __LINE__);
        }
        $this->splitBar = $splitBar;
        return $this;
    }
    /**
     * Get width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param int $width
     * @return \StructType\PanelDisplaySettings
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !is_numeric($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param int $height
     * @return \StructType\PanelDisplaySettings
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !is_numeric($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get originalHeight value
     * @return int|null
     */
    public function getOriginalHeight()
    {
        return $this->originalHeight;
    }
    /**
     * Set originalHeight value
     * @param int $originalHeight
     * @return \StructType\PanelDisplaySettings
     */
    public function setOriginalHeight($originalHeight = null)
    {
        // validation for constraint: int
        if (!is_null($originalHeight) && !is_numeric($originalHeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($originalHeight)), __LINE__);
        }
        $this->originalHeight = $originalHeight;
        return $this;
    }
    /**
     * Get weekViewColumns value
     * @return int|null
     */
    public function getWeekViewColumns()
    {
        return $this->weekViewColumns;
    }
    /**
     * Set weekViewColumns value
     * @param int $weekViewColumns
     * @return \StructType\PanelDisplaySettings
     */
    public function setWeekViewColumns($weekViewColumns = null)
    {
        // validation for constraint: int
        if (!is_null($weekViewColumns) && !is_numeric($weekViewColumns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weekViewColumns)), __LINE__);
        }
        $this->weekViewColumns = $weekViewColumns;
        return $this;
    }
    /**
     * Get calendarView value
     * @return string|null
     */
    public function getCalendarView()
    {
        return $this->calendarView;
    }
    /**
     * Set calendarView value
     * @uses \EnumType\CalendarViewType::valueIsValid()
     * @uses \EnumType\CalendarViewType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calendarView
     * @return \StructType\PanelDisplaySettings
     */
    public function setCalendarView($calendarView = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CalendarViewType::valueIsValid($calendarView)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calendarView, implode(', ', \EnumType\CalendarViewType::getValidValues())), __LINE__);
        }
        $this->calendarView = $calendarView;
        return $this;
    }
    /**
     * Get website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->website;
    }
    /**
     * Set website value
     * @param string $website
     * @return \StructType\PanelDisplaySettings
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($website)), __LINE__);
        }
        $this->website = $website;
        return $this;
    }
    /**
     * Get interval value
     * @return int|null
     */
    public function getInterval()
    {
        return $this->interval;
    }
    /**
     * Set interval value
     * @param int $interval
     * @return \StructType\PanelDisplaySettings
     */
    public function setInterval($interval = null)
    {
        // validation for constraint: int
        if (!is_null($interval) && !is_numeric($interval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($interval)), __LINE__);
        }
        $this->interval = $interval;
        return $this;
    }
    /**
     * Get hScrollPosition value
     * @return int|null
     */
    public function getHScrollPosition()
    {
        return $this->hScrollPosition;
    }
    /**
     * Set hScrollPosition value
     * @param int $hScrollPosition
     * @return \StructType\PanelDisplaySettings
     */
    public function setHScrollPosition($hScrollPosition = null)
    {
        // validation for constraint: int
        if (!is_null($hScrollPosition) && !is_numeric($hScrollPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hScrollPosition)), __LINE__);
        }
        $this->hScrollPosition = $hScrollPosition;
        return $this;
    }
    /**
     * Get vScrollPosition value
     * @return int|null
     */
    public function getVScrollPosition()
    {
        return $this->vScrollPosition;
    }
    /**
     * Set vScrollPosition value
     * @param int $vScrollPosition
     * @return \StructType\PanelDisplaySettings
     */
    public function setVScrollPosition($vScrollPosition = null)
    {
        // validation for constraint: int
        if (!is_null($vScrollPosition) && !is_numeric($vScrollPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vScrollPosition)), __LINE__);
        }
        $this->vScrollPosition = $vScrollPosition;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PanelDisplaySettings
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PanelDisplaySettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
