<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Owner StructType
 * @subpackage Structs
 */
class Owner extends AbstractStructBase
{
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The postOffice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postOffice;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * Constructor method for Owner
     * @uses Owner::setDomain()
     * @uses Owner::setPostOffice()
     * @uses Owner::setUserid()
     * @param string $domain
     * @param string $postOffice
     * @param string $userid
     */
    public function __construct($domain = null, $postOffice = null, $userid = null)
    {
        $this
            ->setDomain($domain)
            ->setPostOffice($postOffice)
            ->setUserid($userid);
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\Owner
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get postOffice value
     * @return string|null
     */
    public function getPostOffice()
    {
        return $this->postOffice;
    }
    /**
     * Set postOffice value
     * @param string $postOffice
     * @return \StructType\Owner
     */
    public function setPostOffice($postOffice = null)
    {
        // validation for constraint: string
        if (!is_null($postOffice) && !is_string($postOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postOffice)), __LINE__);
        }
        $this->postOffice = $postOffice;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\Owner
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Owner
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
