<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization StructType
 * @subpackage Structs
 */
class Organization extends AddressBookItem
{
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemRef
     */
    public $contact;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PostalAddress
     */
    public $address;
    /**
     * The website
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $website;
    /**
     * Constructor method for Organization
     * @uses Organization::setContact()
     * @uses Organization::setPhone()
     * @uses Organization::setFax()
     * @uses Organization::setAddress()
     * @uses Organization::setWebsite()
     * @param \StructType\ItemRef $contact
     * @param string $phone
     * @param string $fax
     * @param \StructType\PostalAddress $address
     * @param string $website
     */
    public function __construct(\StructType\ItemRef $contact = null, $phone = null, $fax = null, \StructType\PostalAddress $address = null, $website = null)
    {
        $this
            ->setContact($contact)
            ->setPhone($phone)
            ->setFax($fax)
            ->setAddress($address)
            ->setWebsite($website);
    }
    /**
     * Get contact value
     * @return \StructType\ItemRef|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\ItemRef $contact
     * @return \StructType\Organization
     */
    public function setContact(\StructType\ItemRef $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Organization
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Organization
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\PostalAddress|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\PostalAddress $address
     * @return \StructType\Organization
     */
    public function setAddress(\StructType\PostalAddress $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->website;
    }
    /**
     * Set website value
     * @param string $website
     * @return \StructType\Organization
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($website)), __LINE__);
        }
        $this->website = $website;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Organization
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
